<?php
    function MessageNoResultFound($Param)
    {
	 echo "No Record Found With Applied Parameter Values,
	  Please check the Parameter entered correctly, 
	  OR  
	  Check The DB Data related to ".$Param." with other entered values combination"; 
    }



if (!function_exists('sql_debug')) {
    function sql_debug($query)
    {
        if (!method_exists($query, 'toSql')) {
            echo "⚠️ Not a query builder instance (already executed or invalid).";
            return;
        }

        $sql = $query->toSql();
        $bindings = $query->getBindings();

        foreach ($bindings as $binding) {
            $binding = is_numeric($binding) ? $binding : "'" . $binding . "'";
            $sql = preg_replace('/\?/', $binding, $sql, 1);
        }

        // ✅ Print as plain text (no HTML dump)
        echo "<pre>$sql</pre>";
    }
}


if (!function_exists('sql_debug_update')) {
    /**
     * Debug UPDATE SQL query before execution.
     *
     * @param \Illuminate\Database\Query\Builder $query
     * @param array $updateData
     * @return void
     */
    function sql_debug_update($query, array $updateData)
    {
        if (!method_exists($query, 'toSql')) {
            echo "⚠️ Not a valid query builder instance.";
            return;
        }

        // Build SET part
        $setPart = [];
        foreach ($updateData as $column => $value) {
            $val = is_numeric($value) ? $value : "'" . $value . "'";
            $setPart[] = "[$column] = $val";
        }
        $setSql = implode(", ", $setPart);

        // Get WHERE part with bindings replaced
        $sql = $query->toSql();
        $bindings = $query->getBindings();

        foreach ($bindings as $binding) {
            $binding = is_numeric($binding) ? $binding : "'" . $binding . "'";
            $sql = preg_replace('/\?/', $binding, $sql, 1);
        }

        // Convert SELECT SQL to UPDATE SQL
        $table = $query->from;
        $updateSql = "UPDATE [$table] SET $setSql " . preg_replace('/^select \* from \[' . preg_quote($table, '/') . '\]/i', '', $sql);

        echo "<pre>$updateSql</pre>";
    }
}




 	function SomeThingWrong($errorno)
    {
	 	echo "Some thing went wrong, Action Aborted".$errorno; 
    }

    function CheckResultSet($ArrayResult)
    {
		$LetsCount= count($ArrayResult); 

		if($LetsCount==0)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

    function GetAmazonOrderFile()
    {
  		$file='amazon.xlsx';
        $filePath = storage_path('app/amazon//' . $file);
        return $filePath ; 
    }
      function GetProductFile()
    {
  		$file='getproduct.json';
        $filePath = storage_path('app/public//' . $file);
        return $filePath ; 
    }

?>
