<?php
namespace App\Helpers;



use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
use App\Helpers\SmsHelper;
use Illuminate\Support\Facades\Config;

class OrdersHelper
{
	public static function getCoo($item, $itemBased = false)
	{
	   $dataReader 		= 	DB::connection('sqlsrv_api')->table('ttcibd001777')
											            ->select('t_ctyo')
											            ->where([
														    		['t_item', '=', $item]
															])
											            ->get();
	   $imCoo = '';
	   foreach ($dataReader as $row) {
		    $imCoo = $row->t_ctyo;
		}
		$dataReader 		= 	DB::connection('sqlsrv_api')->table('ttdipu001777 as PD')
		        										->leftJoin('ttccom130777 as BP', 'PD.t_otbp', '=', 'BP.t_cadr')
		        										->select('t_ccty')
														->where([
														    		['t_item', '=', $item]
															])
								        				->get();
		$pdCoo = '';
	   foreach ($dataReader as $row) {
		    $pdCoo = $row->t_ccty;
		}

	   if ($itemBased && $imCoo)
	   {
	      return $imCoo;
	   }
	   if ($pdCoo <> $imCoo && $pdCoo)
	   {
	      return $pdCoo;
	   }
	   if ( ! $pdCoo && $imCoo)
	   {
	      return $imCoo;
	   } else
	   {
	      return $pdCoo;
	   }
	}
	public static function getCmnf($item)
	{
	   //$dataReader = DB::connection('sqlsrv_api')->select( DB::raw("select t_cmnf from ttcibd001777 where t_item = '$item'") );

        $dataReader 		= 	DB::connection('sqlsrv_api')->table('ttcibd001777')
            ->select('t_cmnf')
            ->where([
                ['t_item', '=', $item]
            ])
            ->get();

	   $imCmnf = '';
	   foreach ($dataReader as $row) {
		    $imCmnf = $row->t_cmnf;
		}
	   return $imCmnf;
	}

	// public static function getBom($item): array
	// {
	//    $item = trim($item);
	//    $sql = "select * from wmwhse1.BILLOFMATERIAL A LEFT JOIN wmwhse1.SKU B on (A.COMPONENTSKU = B.SKU)    WHERE A.SKU = '$item'";
	//    $connection = Yii::$app->get('dbwms');    //
	//    $command = $connection->createCommand($sql);
	//    $dataReader = $command->query();
	//    $bom = [];
	//    while (($row = $dataReader->read()) !== false)
	//    {
	//       $bom [] = $row;
	//    }
	//    return $bom;
	// }

	public static function getDept($item)
	{
//	   $dataReader = DB::connection('sqlsrv_api')->select( DB::raw("select dpm.t_dsca from tpncus113777 dp
//	         left join ttcibd001777 im on (dp.t_citg = im.t_citg)
//	         left join tpncus115777 dpm on (dp.t_dept = dpm.t_dept)
//	         where im.t_item = '$item'") );

        $dataReader = DB::connection('sqlsrv_api')->table('tpncus113777')
            ->leftJoin('ttcibd001777', 'tpncus113777.t_citg', '=', 'ttcibd001777.t_citg')
            ->leftJoin('tpncus115777', 'tpncus113777.t_dept', '=', 'tpncus115777.t_dept')
            ->select('tpncus115777.t_dsca')
            ->where('ttcibd001777.t_item', $item)
            ->get();

	   $imDept = '';
	   foreach ($dataReader as $row) {
           $imDept = $row->t_dsca;
		}
       return $imDept ? $imDept : 'NA';
	}

	public static function instance()
    {
         return new OrdersHelper();
    }
}
