<?php

namespace App\Helpers;

class ApiHelper
{
    public const MYCONST = 'const_value';

    public static function getUserInfo(string $token): array
    {
        $token = urldecode($token);
        $parts = explode('.', $token);

        if (count($parts) !== 3) {
            return [
                'error' => 'Invalid JWT format',
                'dot_count' => substr_count($token, '.'),
            ];
        }

        $payloadJson = base64_decode(strtr($parts[1], '-_', '+/'));
        $payload = json_decode($payloadJson, true);

        if (!is_array($payload)) {
            return [
                'error' => 'Invalid JWT payload',
                'payload_raw' => $payloadJson,
            ];
        }

        return [
            'logged_in_user' => $payload['unique_name'] ?? $payload['email'] ?? null,
            'role'           => $payload['role'] ?? null,
            'iat'            => $payload['iat'] ?? null,
            'exp'            => $payload['exp'] ?? null,
            'expired'        => isset($payload['exp']) ? ($payload['exp'] < time()) : null,
            'raw_payload'    => $payload,
        ];
    }
}
