<?php

namespace App\Services;

class GeoIpService
{
    public function lookup(?string $ip): array
    {
        if (!$ip || $ip === '127.0.0.1' || $ip === '::1') {
            return ['ip' => $ip ?? 'unknown', 'country' => null, 'city' => null, 'lat' => null, 'lon' => null];
        }

        $url = "https://ipapi.co/{$ip}/json/";
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 3,
            CURLOPT_SSL_VERIFYPEER => true
        ]);
        $resp = curl_exec($ch);
        $err  = curl_error($ch);
        curl_close($ch);

        if ($err || !$resp) {
            return ['ip' => $ip, 'country' => null, 'city' => null, 'lat' => null, 'lon' => null];
        }

        $data = json_decode($resp, true) ?: [];
        return [
            'ip'      => $ip,
            'country' => $data['country_name'] ?? null,
            'city'    => $data['city'] ?? null,
            'lat'     => $data['latitude'] ?? null,
            'lon'     => $data['longitude'] ?? null,
        ];
    }
}
