<?php

namespace App\Http\Traits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\DateHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;


trait ScheduleTrait {
    protected $apiDbConnection;
    public function __construct()
    {
        $this->apiDbConnection           =  DB::connection('sqlsrv_api');

    }
    private function checkScheduleDateAvailable($company,$branch,$order_number){

        $db_response        =   $this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)
                                                        ->select(
                                                            DB::raw('max(t_ddat) as scheduled_shipdate'),
                                                            DB::raw('CONVERT(varchar,max(t_ddat), 100) as scheduled_shipdate_readable')
                                                        )
                                                        ->where([
                                                                    ['t_orno', '=', $order_number],
                                                                    ['t_comp', '=', $company],
                                                                    ['t_brch', '=', $branch],
                                                                    ['t_unid', '=', DB::raw('(select max(t_unid) from '.TABLE::DELIVERY_REQUEST.' where t_orno =  \''.$order_number.'\' and t_comp = '.$company.' and [t_brch] = \''.$branch.'\')')],
                                                            ])

                                                        ->first();

        return $db_response;
    }

    private function add_warranty($delivery_date){
        $warranty_date =  date('Y-m-d', strtotime($delivery_date. ' + 2 years'));
        return $warranty_date;
    }


}
