<?php

namespace App\Http\Traits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\DateHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;


trait ImageUrlTrait {
    protected $apiDbConnection;
    private $server_image_folder;
    private $project_image_folder;
    private $image_name;
    public function __construct()
    {
        $this->apiDbConnection           =  DB::connection('sqlsrv_api');
        //$this->item_server_image_folder  =  "//192.168.0.94/baanimg/";    // Old WINDOWS SERVER image path
        $this->item_server_image_folder  =  "//192.168.0.95/botimages/"; //  New WINDOWS SERVER image path
        $this->item_thumb_image_folder   =  public_path('img'.DIRECTORY_SEPARATOR.'api_images'.DIRECTORY_SEPARATOR.'thumb'.DIRECTORY_SEPARATOR);

    }
    public function get_thumb_url($item_number)
    {

        $item_number =  $item_number;
        $image_url = '';

        if(file_exists($this->item_thumb_image_folder.$item_number.'_thumb.jpg')){ // check image file is exist in project public folder
            $image_url = url('img/api_images/thumb/'.$item_number.'_thumb.jpg');
        } else {    // if not exist then check it is availble in server
            $image_source = $this->item_server_image_folder.$item_number.DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.$item_number.'_main.jpg';
            $image_source = $this->item_server_image_folder.$item_number.'/images/'.$item_number.'_main.jpg';
            $image_url = $this->searchImageInServer($image_source,$item_number);
            if($image_url!=''){
                $image_url = url('img/api_images/thumb/'.$item_number.'_thumb.jpg');
            } else {
                $image_url = url('img/api_images/proudct-images/no-image-available_1.jpg');
            }
        }
        if(strpos($image_url, "8080")){
            $image_url = str_replace("http","https",$image_url);
            return str_replace("8080","8443",$image_url);
        } else {
            return $image_url;
        }

    }

    function searchImageInServer($image_source,$item_number){

        if(file_exists($image_source)){
            $image_name = $this->generate_thumb($item_number,$image_source);

        } else {
            $image_name = "";
        }

        return $image_name;
    }




    public function load_image($filename, $type) {
        if( $type == IMAGETYPE_JPEG ) {
            $image = imagecreatefromjpeg($filename);
        }
        elseif( $type == IMAGETYPE_PNG ) {
            $image = imagecreatefrompng($filename);
        }
        elseif( $type == IMAGETYPE_GIF ) {
            $image = imagecreatefromgif($filename);
        }
        return $image;
    }

    public function resize_image($new_width, $new_height, $image, $width, $height,$item_number,$src) {
        $dest = $this->item_thumb_image_folder.$item_number.'_thumb.jpg';
        $new_image = imagecreatetruecolor($new_width, $new_height);
        imagecopyresampled($new_image, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
        imagejpeg($new_image, $dest);
        return $dest;
    }

    public function generate_thumb($item_number,$src)
    {
        $filename = $src;
        list($width, $height, $type) = getimagesize($filename);
        $old_image = $this->load_image($filename, $type);
        $new_image = $this->resize_image(302, 167, $old_image, $width, $height,$item_number,$src);
        return $new_image;
    }
}
