<?php

namespace App\Http\Traits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\DateHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\ScheduleTrait;

trait DeliveryTrait {
    protected $apiDbConnection;
    use ScheduleTrait;
    public function __construct()
    {
        $this->apiDbConnection           =  DB::connection('sqlsrv_api');

    }

    private function checkDeliveryStatus($country_code,$order_number){

        $order_header_response      =   $this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
                                                        ->leftJoin(TABLE::CUSTOMER_DETAILS.$country_code.' as cus', 'oh.t_ofbp', '=', 'cus.t_bpid')
                                                        ->select('oh.t_orno as order_id', 'oh.t_ofbp as account_number','oh.t_odat as order_date','oh.t_ddat as scheduled_shipdate','oh.t_ddat as order_head_delivery_date','oh.t_cofc as branch_code','cus.t_telp as mobile_number','cus.t_mobl as secondary_mobile_number','oh.t_corn as web_order_reference',

                                                            DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
                                                            DB::raw('CONVERT(varchar,oh.t_ddat, 100) as scheduled_shipdate_readable'),

                                                            // DB::raw('FORMAT(oh.t_odat, \'dd-MMM-yyy HH:mm:ss\') as order_date_readable'),
                                                            // DB::raw('FORMAT(oh.t_ddat, \'dd-MMM-yyy HH:mm:ss\') as scheduled_shipdate_readable'),

                                                            DB::raw('ISNULL(cus.t_nama,\'\') as customer_name'),
                                                            DB::raw('(CASE
                                                            WHEN t_hdst = \'2\' THEN \'Suspended\'
                                                            WHEN t_hdst = \'5\' THEN \'Free\'
                                                            WHEN t_hdst = \'10\' THEN \'Approved\'
                                                            WHEN t_hdst = \'20\' THEN \'In Process\'
                                                            WHEN t_hdst = \'25\' THEN \'Modified\'
                                                            WHEN t_hdst = \'30\' THEN \'Closed\'
                                                            WHEN t_hdst = \'35\' THEN \'Cancelled\'
                                                            WHEN t_hdst = \'40\' THEN \'Blocked\'
                                                            WHEN t_hdst = \'45\' THEN \'Released\'
                                                            WHEN t_hdst = \'50\' THEN \'Not Applicable\'
                                                            ELSE \'Not Applicable\'
                                                            END) AS order_status')
                                                    )
                                                        ->where([
                                                                    ['oh.t_orno', '=', $order_number],
                                                                    ['oh.t_sotp ', '<>', 'MSO'],
                                                                    ['oh.t_sotp ', '<>', 'MSR'],
                                                                    ['t_hdst ', '<>', '35'],
                                                            ])
                                                        ->get();

    if(count($order_header_response)>0){
                        $order_line_response        =   $this->apiDbConnection->table(TABLE::ORDER_LINES.$country_code.' as ol')
                                                        ->join(TABLE::ITEM_DETAILS.' as item', 'ol.t_item', '=', 'item.t_item')
                                                        ->select('ol.t_item as item_id', 'item.t_nama as item_name','item.t_sdsc as description',
                                                            DB::raw('CAST(ROUND(ol.t_pric, 2) AS DECIMAL(12,2)) as item_price'),
                                                            DB::raw('cast(ol.t_qoor as int) AS qty'),
                                                             'ol.t_qidl as delivered','ol.t_pono as line_number')
                                                        ->where([
                                                                    ['ol.t_orno', '=', $order_number],
                                                                    ['ol.t_clyn', '<>', '1'],
                                                                    ['ol.t_oltp', '<>', '1'],
                                                                    //[DB::raw('FLOOR(ol.t_qidl)'), '<>', '0'] // order line delivery count temporary removed
                                                            ])
                                                        ->get();

                        if(count($order_line_response)>0){
                            $deliveryStatus = '';
                            $deliveryStatusFlag = 0;
                            $deliveredOrderLineCount = 0;
                            $order_header_response[0]->order_qty = count($order_line_response);
                            $order_header_response[0]->total_amount = 0;
                            foreach ($order_line_response as $key => $value) {
                                if(round(trim($value->delivered)!=0)){
                                    $deliveredOrderLineCount = $deliveredOrderLineCount+1;
                                }
                                $order_header_response[0]->total_amount = $order_header_response[0]->total_amount+$value->item_price;
                                $order_line_response[$key]->item_id = trim($value->item_id);
                                // $image_url = $this->get_thumb_url(trim($value->item_id));
                                // $order_line_response[$key]->image_url = ($image_url!='') ? $image_url : '';
                                if(fmod($value->item_price, 1) !== 0.00){
                                    // if its decimals has a value 85.225454
                                    $value->item_price = round($value->item_price, 2);
                                } else {
                                    //if the decimals are .00, or is an integer
                                    $value->item_price = round($value->item_price, 0);
                                }
                            }


                            ///////////////////////// check delivery status
                            $order_header_response[0]->deliveredOrderLineCount = $deliveredOrderLineCount;
                            $order_header_response[0]->total_amount = round($order_header_response[0]->total_amount, 2);

                            if($order_header_response[0]->order_qty == $order_header_response[0]->deliveredOrderLineCount){
                                $deliveryStatus = 'Fully Delivered';
                                $deliveryStatusFlag = 2;
                            } elseif ( ($order_header_response[0]->order_qty - $order_header_response[0]->deliveredOrderLineCount) == $order_header_response[0]->order_qty){
                                $deliveryStatus = 'Not Yet Delivered';
                                $deliveryStatusFlag = 0;
                            } else {
                                $deliveryStatus = 'Partially Delivered';
                                $deliveryStatusFlag = 1;
                            }
                            $order_header_response[0]->deliveryStatus = $deliveryStatus;
                            $order_header_response[0]->deliveryStatusFlag = $deliveryStatusFlag;
                            //////////////////////// check delivery status


                            //check record available in x2_delivery_request table

                            // $schedule_response  =   $this->checkScheduleDateAvailable($country_code,$order_header_response[0]->branch_code,$order_number);

                            // if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){
                            //     $order_header_response[0]->scheduled_shipdate           = $schedule_response->scheduled_shipdate;
                            //     $order_header_response[0]->scheduled_shipdate_readable  = $schedule_response->scheduled_shipdate_readable;
                            // }

                            //Add warranty info
                            $warranty_date = $this->add_warranty($order_header_response[0]->scheduled_shipdate);
                            $order_header_response[0]->warranty_date = $warranty_date;
                            $order_header_response[0]->warranty_date_readable = date_format(date_create($warranty_date),"d-M-Y H:i:s");


                                $res                        =   $order_header_response[0];
                                $res->items                 =   $order_line_response;
                                $response                   =   array(
                                                                    "order_data"=>$res
                                                                );

                                return $response;
                        } else{
                            return false;
                        }
                    } else {
                        return false;
                    }
    }
}
