<?php

namespace App\Http\Traits;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\DateHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\ScheduleTrait;

trait AuthenticationTrait {
    protected $apiDbConnection;
    use ScheduleTrait;
    public function __construct()
    {
        $this->apiDbConnection           =  DB::connection('sqlsrv_api');

    }

    private function getChannelByEmail($email){
        $purplegrids    = array("shibi@purplegrids.com" => "shibi");
        $shipsy         = array("sabyasachi.haldar@shipsy.io" => "Sabyasachi Haldar","aniket.verma@shipsy.io" => "Aniket Verma","syed.ali@tanla.com" => "Tanla");
        $ivr            = array("ranjan.sharma@omniscienttech.me" => "IVR");

        $company = '';
        if (array_key_exists($email, $purplegrids))
        {
            $channel = 'WEBSITE';
        }
        if (array_key_exists($email, $shipsy))
        {
            $channel = 'WHATSAPP';
        }
        if (array_key_exists($email, $ivr))
        {
            $channel = 'IVR';
        }
        return $channel;
    }

    private function isOnlineOrderOld($webReference){
        $webOrderPrefixList     =   ['UE','OE','QE','KE'];
        $webOrderPrefix         =   substr($webReference, 0,2);
        if (in_array($webOrderPrefix, $webOrderPrefixList) && strlen($webReference)== 8)
        {
            $oder_type    = true;
        } else {
            $oder_type    = false;
        }
        return $oder_type;
    }

    private function isOnlineOrder($salesOffice){

        if (trim($salesOffice) === 'SLSWSU' || trim($salesOffice) === 'SLSWSO' || trim($salesOffice) === 'SLSWSQ' || trim($salesOffice) === 'SLSWSK')
        {
            $onlineOrder = true;
        } else
        {
            $onlineOrder = false;
        }
        return $onlineOrder;
    }
}
