<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Services\JwtService;

class JwtAuth
{
    public function __construct(private JwtService $jwt) {}

    public function handle(Request $request, Closure $next)
    {
        try {
            $claims = $this->jwt->verifyBearerToken($request->header('Authorization', ''));
            // make JWT claims available to controllers if needed
            $request->attributes->set('jwt_claims', $claims);
            return $next($request);
        } catch (\RuntimeException $e) {
            return response()->json(['message' => 'wrong credential'], 401);
        } catch (\Throwable $e) {
            return response()->json(['message' => 'some thing went wrong, check Access Token or Input Formwates'], 401);
        }
    }
}
