<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Support\Api; // <--  helper
use Exception;
use App\Http\Controllers\AuthController;

class TestController extends Controller
{

/**
     * @OA\Get(
     *     path="/api/Test/TestMessage",
     *     summary="GetTest Function",
     *     tags={"Test"},
     *     security={{"bearerAuth":{}}},  
     *      @OA\Response(
     *          response="200",
     *          description="Successful"
     *      ),
     *      @OA\Response(
     *          response=400,
     *          description="Bad Request"
     *      ),
     *      @OA\Response(
     *          response=401,
     *          description="Unauthenticated",
     *      ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     *  )
     */



  public function TestMessage()
    {
 		 echo "Dd";exit;
  
    }

    /**
     * @OA\Get(
     *     path="/api/Test/TestGetData/{orderno}",
     *     summary="GetTest Function",
     *     tags={"Test"},
     *     security={{"bearerAuth":{}}},
      @OA\Parameter(
     *         name="orderno",
     *         in="path",
     *         description="",
     *         required=true,
     *       @OA\Schema(
     *       type="string",
     *       minLength=3,
     *       maxLength=10,
     *        )
     *      ),
     *      @OA\Response(
     *          response="200",
     *          description="Successful"
     *      ),
     *      @OA\Response(
     *          response=400,
     *          description="Bad Request"
     *      ),
     *      @OA\Response(
     *          response=401,
     *          description="Unauthenticated",
     *      ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     *  )
     */

    public function TestGetData(Request $request)
    {
        $OrderNo = trim($request->orderno);  
        $WhereClause='';
        $QueryResult='';
        try
        {   
             $rows = DB::connection('sqlsrv')
             ->table('tpncrm400777 as worko')
             ->where('worko.t_orno', $OrderNo)
             ->select([
                        'worko.t_orno',
                        'worko.t_wref',
                        'worko.t_flag',
                        'worko.t_creg',
                        'worko.t_wrkd',
                     ])
             ->orderBy('worko.t_wrkd')
             ->get();
 
            if (!$rows)
            {
                return response()->json(
                    [
                    'message' => 'Data not found.',
                    ],
                    404);
            }
        }
        catch (Exception $e) 
        {
            return response()->json($e->getMessage(),200); 
            exit;
        }
        return response()->json($rows);
                          
    }

 



   /**
 * @OA\Put(
 *     path="/api/Test/TestCrmData",
 *     summary="GetTest Function",
 *     tags={"Test"},
 *     security={{"bearerAuth":{}}},
 *     @OA\RequestBody(
 *         required=true,
 *         @OA\JsonContent(
 *             required={"order_id","response","delivery_date"},
 *             @OA\Property(property="order_id", type="string", example="SS0300477"),
 *             @OA\Property(property="response", type="string", example="YES"),
 *             @OA\Property(property="delivery_date", type="string", example="2023-07-04"),
 *         )
 *     ),
      *      @OA\Response(
     *          response="200",
     *          description="Successful"
     *      ),
     *      @OA\Response(
     *          response=400,
     *          description="Bad Request"
     *      ),
     *      @OA\Response(
     *          response=401,
     *          description="Unauthenticated",
     *      ),
     *      @OA\Response(
     *          response=403,
     *          description="Forbidden"
     *      )
     *  )
     */

    public function TestCrmData(Request $request)
    {     
          $data = $request->validate([
                'order_id'      => 'required|string',
                'response'      => 'required|string|in:Yes,No,yes,no,YES,NO',
                'delivery_date' => 'required|date_format:Y-m-d',
            ]);

            try
            {
                $orderNumber   = trim($data['order_id']);
                $responseInput = ucfirst(strtolower(trim($data['response']))); // Yes/No
                $deliveryDate  = trim($data['delivery_date']);
                $countryCode   = '777';  

            // ----Function to fetch CRM DB Query  confirm_delivery
            $base = fn() => $this->CrmResult(Api::crm(), $orderNumber, $deliveryDate, $countryCode);
            
            if (!$base()->exists())
            {
                return response()->json(
                    [
						
                        'status'  => false,
                        'message' => 'Sorry, could not find any records for this order in Delivery confirmation Table',
                    ], 404);

                     exit;
            }
        }
        catch (Exception $e) 
        {
            return response()->json($e->getMessage(),200); 
            exit;
        }

        return response()->json(
        [
        
            'status'  => true,
            'message' => 'Test Delivery Confirmation',
        ],
        200);
                
    }
     

// get data from crm DB confirm_delivery
    private function CrmResult($db, string $orderNumber, string $deliveryDate, ?string $countryCode)
    {
        return $db->table('confirm_delivery')
                    ->where('orno', $orderNumber)
                    ->when($countryCode, fn($q) => $q->where('company', $countryCode))
                    ->whereDate('delivery_date', $deliveryDate);
    }







}
