<?php

namespace App\Http\Controllers\Sms;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\SmsHelper;
use App\User;
use Auth;

class SmsController extends Controller
{
    public function sendSms(Request $request){


    	$Data = $request->validate([
    		'phone'=>'required',
    		'message'=>'required'
    	]);

    	$method 	= $request->method();
		$params 	= $request->all();
    	$phone 		= $request->input('phone');
    	$message 	= $request->input('message');

		if($method != 'POST'){
			return response()->json(array('status' => 400,'message' => 'Bad request.'));
		} else {
			if(isset($params['phone']) && isset($params['message'])){

	        	if(($params['phone']!='' || $params['phone']!=null) && ($params['message']!='' || $params['message']!=null) ){
	        		$phone 				= 	stripslashes($request->input('phone'));
		        	$message 			= 	stripslashes($request->input('message'));
					$comp 				= 	$request->input('country_code');
					$phone 				= 	$this->add_country_code($comp,$phone);

					if($phone===false){
						return response()->json(array('status' => 400,'message' => 'Invalid Mobile Number'));
					}

					$sendOtp_status     = 	SmsHelper::instance()->sendSmsAuto($phone, $message); // send OTP
                    $response 			= 	array(
		        								 "status"=>$sendOtp_status
										 );

					return response()->json($response,200);
	        	} else {
	        		return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        	}

	        } else {
	        	return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        }
		}
    }

    public function add_country_code($comp,$phone)
	{

		$phone 			= $this->clean($phone);
		$phone_digits 	= strlen($phone);
		if ($comp === '777') // UAE
		{
			if(substr($phone, 0,5) == '00971' && $phone_digits == 14){
				$phone = "971" .substr($phone, 5);
			} elseif(substr($phone, 0,4)=='+971' && $phone_digits == 13){
				$phone = "971" .substr($phone, 4);
			} elseif(substr($phone, 0,3)=='971' && $phone_digits == 12){
				$phone = "971" .substr($phone, 3);
			} elseif(substr($phone, 0,1)=='0' && $phone_digits == 10){
				$phone = "971" .substr($phone, 1);
			} elseif($phone_digits == 9){
				$phone = "971" .$phone;
			}else {
				$phone = false;
			}
		}
		if ($comp === '100') //OMAN
		{
			//$phone = "968" . $phone;
			if(substr($phone, 0,5) == '00968' && $phone_digits == 13){
				$phone = "968" .substr($phone, 5);
			} elseif(substr($phone, 0,4)=='+968' && $phone_digits == 12){
				$phone = "968" .substr($phone, 4);
			} elseif(substr($phone, 0,3)=='968' && $phone_digits == 11){
				$phone = "968" .substr($phone, 3);
			} elseif(substr($phone, 0,1)=='0' && $phone_digits == 9){
				$phone = "968" .substr($phone, 1);
			} elseif($phone_digits == 8){
				$phone = "968" .$phone;
			}else {
				$phone = false;
			}
		}
		if ($comp === '800') //QATAR
		{

			if(substr($phone, 0,5) == '00974' && $phone_digits == 13){
				$phone = "974" .substr($phone, 5);
			} elseif(substr($phone, 0,4)=='+974' && $phone_digits == 12){
				$phone = "974" .substr($phone, 4);
			} elseif(substr($phone, 0,3)=='974' && $phone_digits == 11){
				$phone = "974" .substr($phone, 3);
			} elseif(substr($phone, 0,1)=='0' && $phone_digits == 9){
				$phone = "974" .substr($phone, 1);
			} elseif($phone_digits == 8){
				$phone = "974" .$phone;
			}else {
				$phone = false;
			}
		}
		if ($comp === '200') //KSA
		{
			//$phone = "966" . substr($phone, 1);
			if(substr($phone, 0,5) == '00966' && $phone_digits == 14){
				$phone = "966" .substr($phone, 5);
			} elseif(substr($phone, 0,4)=='+966' && $phone_digits == 13){
				$phone = "966" .substr($phone, 4);
			} elseif(substr($phone, 0,3)=='966' && $phone_digits == 12){
				$phone = "966" .substr($phone, 3);
			} elseif(substr($phone, 0,1)=='0' && $phone_digits == 10){
				$phone = "966" .substr($phone, 1);
			} elseif($phone_digits == 9){
				$phone = "966" .$phone;
			}else {
				$phone = false;
			}
			//var_dump($phone);die();
		}

		return $phone;
    }

    public function clean($string) {
   		$string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
		return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
	}

   public function testsms( )
   {
   echo "test ayaz";
   }
}
