<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Mail\VerifyEmail;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class RegisterController extends Controller
{
    public function register(Request $request)
{
    $validator = Validator::make($request->all(), [
        'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
        'password' => ['required', 'string', 'min:8', 'confirmed'],
    ]);

    if ($validator->fails()) {
        return new JsonResponse(['success' => false, 'message' => $validator->errors()], 422);
    }

    $user = User::create([       
       'name'         => $request->all()['name'], 
    'email'         => $request->all()['email'],
        'password'      => Hash::make($request->all()['password']),
    ]);
    if ($user) {
    //    $verify2 =  DB::table('password_resets')->where([
      //      ['email', $request->all()['email']]
       // ]);

       // if ($verify2->exists()) {
         //   $verify2->delete();
       // }
        $pin = rand(100000, 999999);
      //  DB::table('password_resets')
          //  ->insert(
              //  [
                //    'email' => $request->all()['email'], 
               //     'token' => $pin
               // ]
           // );
    }
    
    Mail::to($request->email)->send(new VerifyEmail($pin));
        
    $token = $user->createToken('myapptoken')->plainTextToken;
        
    return new JsonResponse(
        [
            'success' => true, 
            'message' => 'Successful created user. Please check your email for a 6-digit pin to verify your email.', 
            'token' => $token
        ], 
        201
    );
}
}
