<?php

namespace App\Http\Controllers\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use App\Helpers\SmsHelper;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\ScheduleTrait;
use App\Http\Traits\ImageUrlTrait;
use App\Http\Traits\AuthenticationTrait;

class OrderController extends Controller
{
	protected $apiDbConnection;
	private $server_image_folder;
	private $project_image_folder;
	private $image_name;
	use ScheduleTrait;
	use AuthenticationTrait;
	use ImageUrlTrait {
        ImageUrlTrait::__construct as private __ImageUrlTConstruct;
    }


	public function __construct()
    {
		$this->apiDbConnection 			 =  DB::connection('sqlsrv_api');
		$this->__ImageUrlTConstruct();
	}

	public static function orderValueVat($orderValue,$company='777')
	{

		$companyToVat = ['777' => 5, '100' => 5, '800' => 0, '200' => 15];
		$vatPercentage = $companyToVat[$company];
		if ($vatPercentage > 0)
		{
			$vatValue = $orderValue * $vatPercentage / 100;
			return round($orderValue + $vatValue, 0);
		}else{
			return $orderValue;
		}
	}

	public function getOrders(Request $request){
    	// Dont send cancelled Orders
    	$method 			= 	$request->method();
		$params 			= 	$request->all();
    	$order_number 		= 	$request->input('order_number');
    	$account_number 	= 	$request->input('account_number');
    	$country_code 		= 	$request->input('country_code');



		if($method != 'GET'){
			return response()->json(array('status' => 400,'message' => 'Bad request.'));
		} else {
			if(isset($params['order_number']) && isset($params['account_number'])){ // go with order number && account number flow
	        	if(($params['order_number']!='' || $params['order_number']!=null) && ($params['account_number']!='' || $params['account_number']!=null) ){
	        		$order_number 				= 	strtoupper(stripslashes($request->input('order_number')));
		        	$account_number 			= 	strtoupper(stripslashes($request->input('account_number')));

		        	 //$this->apiDbConnection->enableQueryLog();
					$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
		        										->leftJoin(TABLE::CUSTOMER_DETAILS.$country_code.' as cus', 'oh.t_ofbp', '=', 'cus.t_bpid')
		        										->select('oh.t_orno as order_id', 'oh.t_ofbp as account_number','oh.t_odat as order_date','oh.t_ddat as scheduled_shipdate','oh.t_ddat as order_head_delivery_date','oh.t_cofc as branch_code','cus.t_telp as mobile_number','cus.t_mobl as secondary_mobile_number',

		        											DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
		        											DB::raw('CONVERT(varchar,oh.t_ddat, 100) as scheduled_shipdate_readable'),

		        											// DB::raw('FORMAT(oh.t_odat, \'dd-MMM-yyy HH:mm:ss\') as order_date_readable'),
		        											// DB::raw('FORMAT(oh.t_ddat, \'dd-MMM-yyy HH:mm:ss\') as scheduled_shipdate_readable'),

		        											DB::raw('ISNULL(cus.t_nama,\'\') as customer_name'),
		        											DB::raw('(CASE
															WHEN t_hdst = \'2\' THEN \'Suspended\'
															WHEN t_hdst = \'5\' THEN \'Free\'
															WHEN t_hdst = \'10\' THEN \'Approved\'
															WHEN t_hdst = \'20\' THEN \'In Process\'
															WHEN t_hdst = \'25\' THEN \'Modified\'
															WHEN t_hdst = \'30\' THEN \'Closed\'
															WHEN t_hdst = \'35\' THEN \'Cancelled\'
															WHEN t_hdst = \'40\' THEN \'Blocked\'
															WHEN t_hdst = \'45\' THEN \'Released\'
															WHEN t_hdst = \'50\' THEN \'Not Applicable\'
															ELSE \'Not Applicable\'
															END) AS order_status')
		        									)
														->where([
														    		['oh.t_orno', '=', $order_number],
														    		['oh.t_ofbp', '=', $account_number],
														    		['oh.t_sotp ', '<>', 'MSO'],
														    		['oh.t_sotp ', '<>', 'MSR'],
														    		['oh.t_sotp ', '<>', 'SR1'],
														    		['t_hdst ', '<>', '35'],
															])
								        				->get();
						// 		        				 $query = $this->apiDbConnection->getQueryLog();
						// dd($query);
					// echo "<pre>";
					// print_r($order_header_response);die();
					if(count($order_header_response)>0){
						$order_line_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_LINES.$country_code.' as ol')
											            ->join(TABLE::ITEM_DETAILS.' as item', 'ol.t_item', '=', 'item.t_item')
											            ->select('ol.t_item as item_id', 'item.t_nama as item_name','item.t_sdsc as description',
											            	DB::raw('CAST(ROUND(ol.t_oamt, 2) AS DECIMAL(12,2)) as item_price'),
											            	DB::raw('CAST(ROUND(ol.t_pric, 2) AS DECIMAL(12,2)) as item_unit_price'),
											            	DB::raw('cast(ol.t_qoor as int) AS qty'),
											            	 'ol.t_qidl as delivered','ol.t_pono as line_number')
											            ->where([
														    		['ol.t_orno', '=', $order_number],
														    		['ol.t_ofbp', '=', $account_number],
														    		['ol.t_clyn', '<>', '1'],
														    		['ol.t_oltp', '<>', '1'],
														    		//[DB::raw('FLOOR(ol.t_qidl)'), '<>', '0'] // order line delivery count temporary removed
															])
											            ->get();

						if(count($order_line_response)>0){

							$deliveryStatus = '';
							$deliveryStatusFlag = 0;
							$deliveredOrderLineCount = 0;
							$order_header_response[0]->order_qty = count($order_line_response);
							$order_header_response[0]->total_amount = 0;
							foreach ($order_line_response as $key => $value) {
								if(round(trim($value->delivered)!=0)){
									$deliveredOrderLineCount = $deliveredOrderLineCount+1;
								}

								$order_line_response[$key]->item_id = trim($value->item_id);
								$image_url = $this->get_thumb_url(trim($value->item_id));
								$order_line_response[$key]->image_url = ($image_url!='') ? $image_url : '';

								$value->item_price = $this->orderValueVat($value->item_price,$country_code);
								$order_header_response[0]->total_amount = $order_header_response[0]->total_amount+$value->item_price;
							}

							/////////// check order status for show schedule delivery option
							if($order_header_response[0]->order_status=='In Process' || $order_header_response[0]->order_status=='Blocked'){
								$order_header_response[0]->show_schedule_delivery_option = true;
							} else {
								$order_header_response[0]->show_schedule_delivery_option = false;
							}



							/////////// check order status for show schedule delivery option

							///////////////////////// check delivery status
							$order_header_response[0]->deliveredOrderLineCount = $deliveredOrderLineCount;
							$order_header_response[0]->total_amount = round($order_header_response[0]->total_amount, 2);

							if($order_header_response[0]->order_qty == $order_header_response[0]->deliveredOrderLineCount){
								$deliveryStatus = 'Fully Delivered';
								$deliveryStatusFlag = 2;
							} elseif ( ($order_header_response[0]->order_qty - $order_header_response[0]->deliveredOrderLineCount) == $order_header_response[0]->order_qty){
								$deliveryStatus = 'Not Yet Delivered';
								$deliveryStatusFlag = 0;
							} else {
								$deliveryStatus = 'Partially Delivered';
								$deliveryStatusFlag = 1;
							}
							$order_header_response[0]->deliveryStatus = $deliveryStatus;
							$order_header_response[0]->deliveryStatusFlag = $deliveryStatusFlag;

							//////////////////////// check delivery status


							//check record available in x2_delivery_request table

							$schedule_response 	= 	$this->checkScheduleDateAvailable($country_code,$order_header_response[0]->branch_code,$order_number);

							if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){
								$order_header_response[0]->scheduled_shipdate 			= $schedule_response->scheduled_shipdate;
								$order_header_response[0]->scheduled_shipdate_readable 	= $schedule_response->scheduled_shipdate_readable;
							}

							//Add warranty info
							$warranty_date = $this->add_warranty($order_header_response[0]->scheduled_shipdate);
							$order_header_response[0]->warranty_date = $warranty_date;
							$order_header_response[0]->warranty_date_readable = date_format(date_create($warranty_date),"d-M-Y H:i:s");

							/////////// check add complaints option
							$today 				= 	date("Y-m-d");
							// $warranty_date = '2021-09-04';
							if ($today > $warranty_date) {
							    $order_header_response[0]->show_add_complaints_option = false;
							    $order_header_response[0]->is_warranty = false;
							}else{

							    $order_header_response[0]->show_add_complaints_option = true;
							    $order_header_response[0]->is_warranty = true;
							}
							//////////////////////////


							// delivery count condition
							// if($deliveryStatusFlag==0){
							// 		return response()->json(array('status' => 400,'message' => 'content Not availble. Not Yet Delivered'));
							// } else {
							// 	$res 						= 	$order_header_response[0];
					  		//       	$res->items 				=	$order_line_response;
					  		//       	$response 					= 	array(
					  		//       										"order_data"=>$res
							// 						        	);

							// 	return response()->json($response,200);
							// }
							// delivery count condition
								$res 						= 	$order_header_response[0];
					        	$res->items 				=	$order_line_response;
					        	$response 					= 	array(
					        										"order_data"=>$res
													        	);

								return response()->json($response,200);
						} else{
							return response()->json(array('status' => 404,'message' => 'Order Details Not Available1'));
						}
					} else {
						return response()->json(array('status' => 404,'message' => 'Order Details Not Available2'));
					}
				} else {
	        		return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        	}

	        } elseif(isset($params['mobile_number'])){ // go with mobile flow

	        	$mobile_number = trim($params['mobile_number']);

	        	// var_dump($mobile_number);die();
	        	$user_record_response 	= 	$this->apiDbConnection->table(TABLE::CUSTOMER_DETAILS.$country_code.' as cus')
													              ->select('cus.t_nama as customer_name','cus.t_telp as mobile_number','cus.t_mobl as secondary_mobile_number','cus.t_bpid as account_number')
													              ->where('cus.t_bpst','=',2)
													              ->where('cus.t_telp','=',$mobile_number)
													              ->first();
				if(!empty($user_record_response)){
					$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
		        														  ->leftJoin(TABLE::CUSTOMER_DETAILS.$country_code.' as cus', 'oh.t_ofbp', '=', 'cus.t_bpid')
		        														  ->select('oh.t_orno as order_id','oh.t_ofbp as account_number', 'oh.t_odat as order_date','oh.t_ddat as scheduled_shipdate','oh.t_ddat as order_head_delivery_date','cus.t_nama as customer_name','oh.t_cofc as branch_code','oh.t_corn as web_order_reference',

		        														  	DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
		        														  	DB::raw('CONVERT(varchar,oh.t_ddat, 100) as scheduled_shipdate_readable'),

		        														  	// DB::raw('FORMAT(oh.t_odat, \'dd-MMM-yyy HH:mm:ss\') as order_date_readable'),
		        														  	// DB::raw('FORMAT(oh.t_ddat, \'dd-MMM-yyy HH:mm:ss\') as scheduled_shipdate_readable'),
						        											DB::raw('(CASE
																			WHEN t_hdst = \'2\' THEN \'Suspended\'
																			WHEN t_hdst = \'5\' THEN \'Free\'
																			WHEN t_hdst = \'10\' THEN \'Approved\'
																			WHEN t_hdst = \'20\' THEN \'In Process\'
																			WHEN t_hdst = \'25\' THEN \'Modified\'
																			WHEN t_hdst = \'30\' THEN \'Closed\'
																			WHEN t_hdst = \'35\' THEN \'Cancelled\'
																			WHEN t_hdst = \'40\' THEN \'Blocked\'
																			WHEN t_hdst = \'45\' THEN \'Released\'
																			WHEN t_hdst = \'50\' THEN \'Not Applicable\'
																			ELSE \'Not Applicable\'
																			END) AS order_status')
						        									)->where([
																	    		['oh.t_ofbp', '=', $user_record_response->account_number],
																	    		['oh.t_sotp ', '<>', 'MSO'],
														    					['oh.t_sotp ', '<>', 'MSR'],
														    					['oh.t_sotp ', '<>', 'SR1'],
														    					['t_hdst ', '<>', '35'],

																		])->get();

						foreach ($order_header_response as $key => $value) {
							//check record available in x2_delivery_request table
							$schedule_response 	= 	$this->checkScheduleDateAvailable($country_code,$value->branch_code,$value->order_id);
							if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){

								$value->scheduled_shipdate 			= $schedule_response->scheduled_shipdate;
								$value->scheduled_shipdate_readable = $schedule_response->scheduled_shipdate_readable;
							}


							$od_time 	=	strtotime($value->order_date);
							$od_month 	=	strtoupper(date("M",$od_time));
							$od_year 	=	date("y",$od_time);
							$order_date = 	' - '.$od_month.' '.$od_year;
							// identify order type (online/offline order)
							if ($this->isOnlineOrder($value->branch_code))
							{
								if($value->web_order_reference!=''){
									$value->display_order_number = $value->web_order_reference.$order_date;
								} else {
									$value->display_order_number = $value->order_id.$order_date;
								}

								$value->oder_type    = 'online';
							}
							else
							{
								$value->display_order_number = $value->order_id.$order_date;
								$value->oder_type    = 'offline';
							}


							//Add warranty info
							$warranty_date = $this->add_warranty($value->scheduled_shipdate);
							$value->warranty_date = $warranty_date;
							$value->warranty_date_readable = date_format(date_create($warranty_date),"d-M-Y H:i:s");
						}

						$response 	= 	array(
	        								"order_header"=>$order_header_response
									    );
					return response()->json($response,200);
				} else {
					return response()->json(array('status' => 404,'message' => 'User Details Not Available'));
				}
			} elseif(isset($params['order_number'])){ // go with web orders
				if(($params['order_number']!='' || $params['order_number']!=null)){
					$web_reference_number 		= 	strtoupper(stripslashes($request->input('order_number')));

		        	$order_number 				=  '';
		        	$oder_type 					= '';



		        	$order_number_response 		= 	$this->apiDbConnection->table(TABLE::WEB_ORDERS)
													               ->select('t_orno as order_number')
													               ->where([
																    		['t_wref', '=', $web_reference_number],
																    		['t_ncmp', '=', $country_code],
																   ])
													               ->first();


					if(!empty($order_number_response)){
						$order_number = $order_number_response->order_number;
						$oder_type    = 'online';
					} else {
						$order_number = $web_reference_number;
						$oder_type    = 'offline';
					}


					$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
		        										->leftJoin(TABLE::CUSTOMER_DETAILS.$country_code.' as cus', 'oh.t_ofbp', '=', 'cus.t_bpid')
		        										->select('oh.t_orno as order_id', 'oh.t_ofbp as account_number','oh.t_odat as order_date','oh.t_ddat as scheduled_shipdate','oh.t_ddat as order_head_delivery_date','oh.t_cofc as branch_code','cus.t_telp as mobile_number','cus.t_mobl as secondary_mobile_number',

		        											DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
		        											DB::raw('CONVERT(varchar,oh.t_ddat, 100) as scheduled_shipdate_readable'),

		        											// DB::raw('FORMAT(oh.t_odat, \'dd-MMM-yyy HH:mm:ss\') as order_date_readable'),
		        											// DB::raw('FORMAT(oh.t_ddat, \'dd-MMM-yyy HH:mm:ss\') as scheduled_shipdate_readable'),

		        											DB::raw('ISNULL(cus.t_nama,\'\') as customer_name'),
		        											DB::raw('(CASE
															WHEN t_hdst = \'2\' THEN \'Suspended\'
															WHEN t_hdst = \'5\' THEN \'Free\'
															WHEN t_hdst = \'10\' THEN \'Approved\'
															WHEN t_hdst = \'20\' THEN \'In Process\'
															WHEN t_hdst = \'25\' THEN \'Modified\'
															WHEN t_hdst = \'30\' THEN \'Closed\'
															WHEN t_hdst = \'35\' THEN \'Cancelled\'
															WHEN t_hdst = \'40\' THEN \'Blocked\'
															WHEN t_hdst = \'45\' THEN \'Released\'
															WHEN t_hdst = \'50\' THEN \'Not Applicable\'
															ELSE \'Not Applicable\'
															END) AS order_status')
		        									)
														->where([
														    		['oh.t_orno', '=', $order_number],
														    		['oh.t_sotp ', '<>', 'MSO'],
														    		['oh.t_sotp ', '<>', 'MSR'],
														    		['oh.t_sotp ', '<>', 'SR1'],
														    		['t_hdst ', '<>', '35'],
															])
								        				->get();
					if(count($order_header_response)>0){
						$order_line_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_LINES.$country_code.' as ol')
											            ->join(TABLE::ITEM_DETAILS.' as item', 'ol.t_item', '=', 'item.t_item')
											            ->select('ol.t_item as item_id', 'item.t_nama as item_name','item.t_sdsc as description',
											            	DB::raw('CAST(ROUND(ol.t_oamt, 2) AS DECIMAL(12,2)) as item_price'),
											            	DB::raw('cast(ol.t_qoor as int) AS qty'),
											            	 'ol.t_qidl as delivered','ol.t_pono as line_number')
											            ->where([
														    		['ol.t_orno', '=', $order_number],
														    		['ol.t_clyn', '<>', '1'],
														    		['ol.t_oltp', '<>', '1'],
														    		//[DB::raw('FLOOR(ol.t_qidl)'), '<>', '0'] // order line delivery count temporary removed
															])
											            ->get();

						if(count($order_line_response)>0){
							$deliveryStatus = '';
							$deliveryStatusFlag = 0;
							$deliveredOrderLineCount = 0;
							$order_header_response[0]->order_qty = count($order_line_response);
							$order_header_response[0]->total_amount = 0;
							foreach ($order_line_response as $key => $value) {
								if(round(trim($value->delivered)!=0)){
									$deliveredOrderLineCount = $deliveredOrderLineCount+1;
								}

								$order_line_response[$key]->item_id = trim($value->item_id);
								$image_url = $this->get_thumb_url(trim($value->item_id));
								$order_line_response[$key]->image_url = ($image_url!='') ? $image_url : '';
								$value->item_price = $this->orderValueVat($value->item_price,$country_code);
								$order_header_response[0]->total_amount = $order_header_response[0]->total_amount+$value->item_price;
							}


							///////////////////////// check delivery status
							$order_header_response[0]->deliveredOrderLineCount = $deliveredOrderLineCount;
							$order_header_response[0]->total_amount = round($order_header_response[0]->total_amount, 2);

							if($order_header_response[0]->order_qty == $order_header_response[0]->deliveredOrderLineCount){
								$deliveryStatus = 'Fully Delivered';
								$deliveryStatusFlag = 2;
							} elseif ( ($order_header_response[0]->order_qty - $order_header_response[0]->deliveredOrderLineCount) == $order_header_response[0]->order_qty){
								$deliveryStatus = 'Not Yet Delivered';
								$deliveryStatusFlag = 0;
							} else {
								$deliveryStatus = 'Partially Delivered';
								$deliveryStatusFlag = 1;
							}
							$order_header_response[0]->deliveryStatus = $deliveryStatus;
							$order_header_response[0]->deliveryStatusFlag = $deliveryStatusFlag;
							//////////////////////// check delivery status


							//check record available in x2_delivery_request table

							$schedule_response 	= 	$this->checkScheduleDateAvailable($country_code,$order_header_response[0]->branch_code,$order_number);

							if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){
								$order_header_response[0]->scheduled_shipdate 			= $schedule_response->scheduled_shipdate;
								$order_header_response[0]->scheduled_shipdate_readable 	= $schedule_response->scheduled_shipdate_readable;
							}

							//Add warranty info
							$warranty_date = $this->add_warranty($order_header_response[0]->scheduled_shipdate);
							$order_header_response[0]->warranty_date = $warranty_date;
							$order_header_response[0]->warranty_date_readable = date_format(date_create($warranty_date),"d-M-Y H:i:s");
							$order_header_response[0]->order_tpye = $oder_type;

							//mobile number hint
							$mobile = $order_header_response[0]->mobile_number;
							if($mobile!='' && strlen($mobile)>0){
								$order_header_response[0]->mobile_number_hint  = str_repeat('*', strlen($mobile) - 3) . substr($mobile, -3);
							}

							// delivery count condition
							// if($deliveryStatusFlag==0){
							// 		return response()->json(array('status' => 400,'message' => 'content Not availble. Not Yet Delivered'));
							// } else {
							// 	$res 						= 	$order_header_response[0];
					  		//       	$res->items 				=	$order_line_response;
					  		//       	$response 					= 	array(
					  		//       										"order_data"=>$res
							// 						        	);

							// 	return response()->json($response,200);
							// }
							// delivery count condition
								// sort($order_header_response[0]);die();
								$res 						= 	$order_header_response[0];
					        	$res->items 				=	$order_line_response;
					        	$response 					= 	array(
					        										"order_data"=>$res
													        	);

								return response()->json($response,200);
						} else{
							return response()->json(array('status' => 404,'message' => 'Order Details Not Available1'));
						}
					} else {
						return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
					}
				} else {
	        		return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        	}
			} else {
	        	return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        }
		}
    }







}
