<?php

namespace App\Http\Controllers\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use App\Helpers\SmsHelper;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\ImageUrlTrait;


class ItemController extends Controller
{
	protected $apiDbConnection;
	private $server_image_folder;
	private $project_image_folder;
	private $image_name;
	use ImageUrlTrait {
        ImageUrlTrait::__construct as private __ImageUrlTConstruct;
    }

	public function __construct()
    {

		$this->apiDbConnection 			 =  DB::connection('sqlsrv_api');
		$this->__ImageUrlTConstruct();

	}

	public function getItems(Request $request){

    	$method 			= 	$request->method();
		$params 			= 	$request->all();
		$regionList 		=   ['777' => 'uae', "800" => 'qatar', "100" => 'oman', "200" => 'ksa'];
    	// $searchKey 			= 	strtolower($request->input('query'));
    	// $searchKey 			= 	str_replace("'", "", stripslashes($searchKey));
    	// $searchKey 			= 	str_replace(';', '', $searchKey);
    	$searchKey 			= 	$this->cleanString(strtolower($request->input('query')));


    	$country_code 		= 	$this->cleanString($request->input('country_code'));
    	$country_name       =   $regionList[$country_code];
    	$display_count 		= 	10;
    	$limit_skip 		= 	0;   // limit Start from API
    	$limit_to 			= 	10;  // limit End from API
		if(isset($params['limit_skip']) && isset($params['limit_to'])){
	        	if(($params['limit_skip']!='' || $params['limit_skip']!=null) && ($params['limit_to']!='' || $params['limit_to']!=null) ){
	        			$limit_skip = $request->input('limit_skip');
	        			$limit_to = $request->input('limit_to');
	        	}
	    }
		if($method != 'GET'){
			return response()->json(array('status' => 400,'message' => 'Bad request.'));
		} else {
			if(isset($params['query'])){
				if(($params['query']!='' || $params['query']!=null)){

					$AND = "";

					// $deptsql = "SELECT t_dept as department ,t_dsca as name FROM ". TABLE::ITEM_DEPARTMENT." WHERE LOWER( t_dsca ) like '%$searchKey%'";

//                    $deptsql = "SELECT t_dept as department ,t_dsca as name FROM ". TABLE::ITEM_DEPARTMENT." WHERE LOWER( t_dsca ) = '$searchKey'";
//					$item_department_response = $this->apiDbConnection->select( DB::raw($deptsql));




                    $item_department_response = DB::connection('sqlsrv_api')
                        ->table(TABLE::ITEM_DEPARTMENT)
                        ->selectRaw('t_dept as department, t_dsca as name')
                        ->whereRaw('LOWER(t_dsca) = ?', [strtolower($searchKey)])
                        ->get();

                    //echo "here1";die();

					//**************************************************************************************************
					// Raw Sql
					// show based on department if customer search sofa then show product under the sofa (Enhancement code)
					$departmentLike = '';

					if(!empty($item_department_response)){
						$departmentLike = 'AND (';
						foreach ($item_department_response as $key => $value) {
							if($key==0){
								$departmentLike = $departmentLike."i.t_citg like '_".$value->department."___'";
							} else {
								$departmentLike = $departmentLike." OR i.t_citg like '_".$value->department."___'";
							}
						}
						$departmentLike = $departmentLike.')';
						$sql = "SELECT id.t_item as item_id,id.t_nama as item_name, id.t_sdsc,ip.t_pric as price_now,ip.t_pris as price_was,ip.t_efdt as price_start_date,ip.t_exdt as price_end_date,ip.t_crnt,ip.t_ncmp,ROW_NUMBER() OVER (ORDER BY id.t_item) row_num FROM ". TABLE::ITEM_DETAILS." as id JOIN ".TABLE::ITEM_PRICE." as ip ON id.t_item = ip.t_item JOIN ".TABLE::ITEM." as i ON i.t_item=id.t_item JOIN ".TABLE::ITEM_AVAILABILITY.$country_code." as ia ON ia.t_item=id.t_item WHERE ip.t_ncmp ='".$country_code."' AND (ia.t_stoc-ia.t_blck-ia.t_allo)>0 AND id.t_colr <> 'D' AND ip.t_crnt=1 ".$departmentLike."";
					} else {
						// show based on item name or item number (Enhancement code)
						$sql = "SELECT id.t_item as item_id,id.t_nama as item_name, id.t_sdsc,ip.t_pric as price_now,ip.t_pris as price_was,ip.t_efdt as price_start_date,ip.t_exdt as price_end_date,ip.t_crnt,ip.t_ncmp,ROW_NUMBER() OVER (ORDER BY id.t_item) row_num FROM ". TABLE::ITEM_DETAILS." as id JOIN ".TABLE::ITEM_PRICE." as ip ON id.t_item = ip.t_item JOIN ".TABLE::ITEM." as i ON i.t_item=id.t_item JOIN ".TABLE::ITEM_AVAILABILITY.$country_code." as ia ON ia.t_item=id.t_item WHERE ip.t_ncmp ='".$country_code."' AND (ia.t_stoc-ia.t_blck-ia.t_allo)>0 AND id.t_colr <> 'D' AND ip.t_crnt=1 ".$AND." AND (LOWER( id.t_nama ) like '$searchKey%' OR LOWER(id.t_desc) like '$searchKey%' OR id.t_item like '%$searchKey') ";
					}
					// Raw Sql
					$queryStart = "WITH t AS (";
					$queryEnd 	= ") SELECT * FROM t WHERE row_num BETWEEN 1 AND 10";
					$sql = $queryStart.$sql.$queryEnd;
					// echo $sql;die();
					//$item_detail_response = $this->apiDbConnection->select( DB::raw($sql));
					//********************************************************************************************************


					// query builder-------------------------------------------
					// $this->apiDbConnection->enableQueryLog();
					if(!empty($item_department_response)){

						$query_res 		= 	$this->apiDbConnection->table(TABLE::ITEM_DETAILS.' as id')
											            ->join(TABLE::ITEM_PRICE.' as ip', 'id.t_item', '=', 'ip.t_item')
											            ->join(TABLE::ITEM.' as i', 'i.t_item', '=', 'id.t_item')
											            ->join(TABLE::ITEM_AVAILABILITY.$country_code.' as ia', 'ia.t_item', '=', 'id.t_item')
											            ->select('id.t_item as item_id','id.t_nama as item_name', 'id.t_sdsc','ip.t_pric as price_now','ip.t_pris as price_was','ip.t_efdt as price_start_date','ip.t_exdt as price_end_date','ip.t_crnt','ip.t_ncmp')
											            ->where([
														    		['ip.t_ncmp', '=', $country_code],
														    		['id.t_colr', '<>', 'D'],
														    		['ip.t_crnt', '=', '1'],
														    		['id.t_cweb', '=', '1'],
														    		[DB::raw('(ia.t_stoc-ia.t_blck-ia.t_allo)'), '>', 1]

														    ])
											            ->where(function($query) use ($searchKey,$item_department_response) {
											            		foreach ($item_department_response as $key => $value) {
											            			if(($key+1)==1 && count($item_department_response)==($key+1)){
																		$query->where(DB::raw('i.t_citg'), 'LIKE', '_'.$value->department.'___');
																	} elseif(($key+1)==1){
																		$query->where(DB::raw('i.t_citg'), 'LIKE', '_'.$value->department.'___');
															        } elseif(count($item_department_response)==$key){
																		$query->orWhere(DB::raw('i.t_citg'), 'LIKE', '_'.$value->department.'___');
															        } else{
																		$query->orWhere(DB::raw('i.t_citg'), 'LIKE', '_'.$value->department.'___');
															        }
																}
														    })
											            ->take($limit_to)->skip($limit_skip)->get();

					} else {

						//$this->apiDbConnection->enableQueryLog();
						$query_res 		= 	$this->apiDbConnection->table(TABLE::ITEM_DETAILS.' as id')
											            ->join(TABLE::ITEM_PRICE.' as ip', 'id.t_item', '=', 'ip.t_item')
											            ->join(TABLE::ITEM.' as i', 'i.t_item', '=', 'id.t_item')
											            ->join(TABLE::ITEM_AVAILABILITY.$country_code.' as ia', 'ia.t_item', '=', 'id.t_item')
											            ->select('id.t_item as item_id','id.t_nama as item_name', 'id.t_sdsc','id.t_desc','ip.t_pric as price_now','ip.t_pris as price_was','ip.t_efdt as price_start_date','ip.t_exdt as price_end_date','ip.t_crnt','ip.t_ncmp')
											            ->where([
														    		['ip.t_ncmp', '=', $country_code],
														    		['id.t_colr', '<>', 'D'],
														    		['ip.t_crnt', '=', '1'],
														    		['id.t_cweb', '=', '1'],
														    		[DB::raw('(ia.t_stoc-ia.t_blck-ia.t_allo)'), '>', 1]

														    ])
											            ->where(function($query) use ($searchKey) {
														    $query->where(DB::raw('lower(id.t_nama)'), 'LIKE', '%'.$searchKey.'%')
														        ->orWhere(DB::raw('lower(id.t_sdsc)'), 'LIKE', '%'.$searchKey.'%')
														        ->orWhere(DB::raw('lower(id.t_item)'), 'LIKE', '%'.$searchKey);
														        })
											             ->take($limit_to)->skip($limit_skip)->get();
						 // $query = $this->apiDbConnection->getQueryLog();
						 // dd($query);
					}


					//$query1 = $this->apiDbConnection->getQueryLog();
					// dd($query1);die();
					// query builder-----------------------------------------------

					$item_detail_response = $query_res;

					foreach ($item_detail_response as $key => $value) {
						$item_detail_response[$key]->item_id = trim($value->item_id);

						$image_url = $this->get_thumb_url(trim($value->item_id));

						$item_detail_response[$key]->image_url = ($image_url!='') ? $image_url : '';
						//$item_detail_response[$key]->link = 'https://www.panemirates.com/uae/en/search/'.trim($value->item_id);
						$item_detail_response[$key]->link = 'https://www.panhomestores.com/'.$country_name.'_en/search/'.trim($value->item_id);
					}

					$response 	= 	array("item_details"=>$item_detail_response);
					return response()->json($response,200);
				} else {
					return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
			}
		}
	}



}
