<?php

namespace App\Http\Controllers\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
use App\Helpers\Geocoding;
use App\Helpers\Translate;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\AuthenticationTrait;


class HomeController extends Controller
{
	protected $apiDbConnection;
	use AuthenticationTrait;


	public function __construct()
    {
		$this->apiDbConnection   =  DB::connection('sqlsrv_api');

	}


    public function addFeedback(Request $request)
	{
		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));
		$today 						= 	date("Y-m-d");
		$order_number 				= 	"";
		$item_number 				= 	"";


		if (array_key_exists("issueType",$request_data) && array_key_exists("description",$request_data) && array_key_exists("customerDetails",$request_data) && array_key_exists("feedback",$request_data))
		{
			if($request_data['issueType']!='' && $request_data['description']!='' && $request_data['customerDetails']!='' && $request_data['feedback']!=''){
				if(array_key_exists("itemId",$request_data) && $request_data['itemId']!=''){
					$item_number 				= 	$this->cleanString($request_data['itemId']);
				}
				if(array_key_exists("orderId",$request_data) && $request_data['orderId']!=''){
					$order_number 				= 	$this->cleanString($request_data['orderId']);
				}
				$record = array(
								'classification'	=>	$this->cleanString($request_data['issueType']),
								'company'			=>	$country_code,
								'orderNumber'		=>	$order_number,
								'itemNumber'		=>	$item_number,
								'description'		=>	$this->cleanString($request_data['description']),
								'feedback'			=>	$request_data['feedback'],
								'createdAt'			=>	$today,
								'created_by'		=>	"chatbot",
								'flag'				=>	'1',
								'customer_details'	=> json_encode($request_data['customerDetails'])
				        	);

				$response = $this->apiDbConnection->table(TABLE::BOT_FEEDBACKS)->insert($record);

				if($response){
					$res = array(
						'status'=>true,
						'message'=>"Feedback added successfully",
					);
					return response()->json($res,200);
				} else{
					return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}

	public function addCallback(Request $request)
	{
		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));
		$today 						= 	date("Y-m-d");

		if (array_key_exists("name",$request_data) && array_key_exists("phone",$request_data) && array_key_exists("reason",$request_data))
		{
			if($request_data['name']!='' && $request_data['phone']!='' && $request_data['reason']!=''){

				$activity = '';
				if(isset($request_data['activity'])){
					$activity = $this->cleanString($request_data['activity']);
					if($activity !== ''){
						if(strlen($activity)>249){
							$startingDigit = strlen($activity)+3 - 249;
							$activity = '...'.substr($activity, $startingDigit,246);
						} else {
							$activity = $activity;
						}
					}
				}
				$record = array(
								'name'	=>	$request_data['name'],
								'phone'			=>	$this->cleanString($request_data['phone']),
								'reason'		=>	$this->cleanString($request_data['reason']),
								'activity'		=>  $activity,
								'createdAt'		=>	$today,
								'createdBy'		=>	"chatbot",
							);

				$response = $this->apiDbConnection->table(TABLE::BOT_CALLBACKS)->insert($record);

				if($response){
					$res = array(
						'status'=>true,
						'message'=>"Callback added successfully",
					);
					return response()->json($res,200);
				} else{
					return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}

	public function getFormatedAddress($lat,$long){
		$translate 		= 	new Translate();
		$geo 			= 	new Geocoding("AIzaSyAcoakHUhUZ4gkUeHzlTdhirK4aoCQFFao");
		$geoAddress 	= 	$geo->getAddress($lat,$long);

		if($geoAddress !== false){
			$addressArray 	= 	array_reverse($geo->getAddress($lat,$long));
		} else {
			$addressArray 	= 	[];
		}
        // echo "<pre>";
        // print_r($addressArray);

		$addressArrayNew = [];

        foreach ($addressArray as $key=> $value){
            $adress 				= 	$translate->arb2en($value->long_name);
            $adress 				= 	preg_replace("/[^0-9a-zA-Z ]/i", "", $adress);
            $addressArrayNew[$key]  =   $adress;
        }

        $arrayCount = count($addressArrayNew);
        $response = [];

        if($arrayCount === 1){
        	$response['city'] = $this->cleanString($addressArrayNew[0]);
        	$response['area'] = $this->cleanString($addressArrayNew[0]);
        	$response['addr'] = $this->cleanString($addressArrayNew[0]);
        }
        if($arrayCount === 2){
        	$response['city'] = $this->cleanString($addressArrayNew[0]);
        	$response['area'] = $this->cleanString($addressArrayNew[1]);
        	$response['addr'] = $this->cleanString($addressArrayNew[1]);
        }
        if($arrayCount === 3){
        	$response['city'] = $this->cleanString($addressArrayNew[0]);
        	$response['area'] = $this->cleanString($addressArrayNew[1]);
        	$response['addr'] = $this->cleanString($addressArrayNew[2]);
        } else if($arrayCount === 4){
        	$response['city'] = $this->cleanString($addressArrayNew[1]);
        	$response['area'] = $this->cleanString($addressArrayNew[2]);
        	$response['addr'] = $this->cleanString($addressArrayNew[3]);
        } else if($arrayCount === 5){
        	$response['city'] = $this->cleanString($addressArrayNew[1]);
        	$response['area'] = $this->cleanString($addressArrayNew[3]);
        	$response['addr'] = $this->cleanString($addressArrayNew[4]);

        } else if($arrayCount === 6){
        	$response['city'] = $this->cleanString($addressArrayNew[1]);
        	$response['area'] = $this->cleanString($addressArrayNew[3]);
        	$response['addr'] = $this->cleanString($addressArrayNew[5]);

        } else if($arrayCount > 6){
        	$response['city'] = $this->cleanString($addressArrayNew[1]);
        	$response['area'] = $this->cleanString($addressArrayNew[3]);
        	$response['addr'] = $this->cleanString($addressArrayNew[5]);
        }

		return $response;

	}

	public function updateUserLocation(Request $request)
	{

		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));

		$today 						= 	date("Y-m-d h:i:s");
		if (array_key_exists("order_id",$request_data) && array_key_exists("lat",$request_data) && array_key_exists("long",$request_data))
		{
			if($request_data['order_id']!='' && $request_data['lat']!="" && $request_data['long']!=""){

				$order_number 		= 	$this->cleanString($request_data['order_id']);
				$lat 				= 	$this->cleanString($request_data['lat']);
				$long 				= 	$this->cleanString($request_data['long']);
				$city 				= 	'';
				$area 				= 	'';
				$addr 				= 	'';
				$building_info   	= 	'';

				if(isset($request_data['building_info']))
				{
					$translate 			= 	new Translate();

					$building_info 		= 	$translate->arb2en($request_data['building_info']);
					$building_info 		= 	$this->cleanString($building_info);
					$building_info 		=  	str_replace(',', ' ', $building_info);
					$building_info 		= 	preg_replace("/[^a-zA-Z0-9\s]+/", "", $building_info);


				}


				$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
													            ->select('oh.t_odat as order_date','oh.t_ofbp as customer_id','oh.t_ddat as delivery_date','oh.t_cofc as office_code',

													            	DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
													            	DB::raw('CONVERT(varchar,oh.t_ddat, 100) as delivery_date_readable')
													        	)
													            ->where([
																    		['oh.t_orno', '=', $order_number],
																    		['oh.t_sotp ', '<>', 'MSO'],
																			['oh.t_sotp ', '<>', 'MSR'],
																			['oh.t_sotp ', '<>', 'SR1'],
																			['oh.t_hdst ', '<>', '35'],
																	])
													            ->first();
				// echo "<pre>";
				// print_r($order_header_response);die();
			   	if(!empty($order_header_response))
			   	{ // check if record exist

			   		// fetch address from lat & long
					$addresRes = $this->getFormatedAddress($lat,$long);

					if(!empty($addresRes))
					{
						$city 		= 	substr($addresRes['city'],0,48);
						$area 		= 	substr($addresRes['area'],0,48);
						$addr 		= 	substr($addresRes['addr'],0,48);
					}

					if($building_info =='' ){
						$response = $this->apiDbConnection->table(TABLE::SALES_ORDER_ADDITIONAL.$country_code)
											  ->where([
											    		['t_orno', '=', $order_number],

			    								])->update([
			    									't_glat' => $lat,
			    									't_glon' => $long,
			    									't_gcty' => $city,
			    									't_gare' => $area,
			    									't_gsar' => $addr
			    								]);
					} else {
						$response = $this->apiDbConnection->table(TABLE::SALES_ORDER_ADDITIONAL.$country_code)
											  ->where([
											    		['t_orno', '=', $order_number],

			    								])->update([
			    									't_glat' => $lat,
			    									't_glon' => $long,
			    									't_gcty' => $city,
			    									't_gare' => $area,
			    									't_gsar' => $addr,
			    									//'t_ln03' => $building_info
			    								]);
					}

					if($response)
					{
						$res = array(
							'status'=>true,
							'message'=>"Location Updated successfully",
						);
						return response()->json($res,200);
					} else{
						return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
					}
				} else {
					return response()->json(array('status' => 404,'message' => 'Sorry, could not find any records for this order'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}

	public function updateDeliveryConfirmation(Request $request)
	{
		date_default_timezone_set('Asia/Dubai');
		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));
		$this->apiDbConnection 		=  	DB::connection('dbcrm');
		$today 						= 	date('Y-m-d H:i:s');

//		$user 			= 	auth()->user();
//		$channel 		= 	$this->getChannelByEmail($user->email);

        $channel = '';
		if (array_key_exists("order_id",$request_data) && array_key_exists("response",$request_data) && array_key_exists("delivery_date",$request_data))
		{
			if($request_data['order_id'] !='' && $request_data['response'] !="" && $request_data['delivery_date'] !=""){

				$order_number 		= 	$this->cleanString($request_data['order_id']);
				// $response 			= 	strtoupper($this->cleanString($request_data['response']));
				$response 			= 	$this->cleanString($request_data['response']);

				$deliveryDate 			= 	$this->cleanString($request_data['delivery_date']);

				if($response === 'yes' || $response === 'no' || $response === 'YES' || $response === 'NO'){
					$response = ucfirst(strtolower($response));
				} else {
					$response = $response;
				}

				$deliveryConfirmation 		= 	$this->apiDbConnection->table(TABLE::DELIVERY_CONFIRMATION.' as dc')
													            ->select('dc.id','dc.delivery_date','dc.orno')
													            ->where([
																    		['dc.orno', '=', $order_number],
																    		['dc.delivery_date', '=', $deliveryDate],
																	])
													            ->get();
					// echo "<pre>";
					// print_r($deliveryConfirmation);die();
				if(!empty($deliveryConfirmation)){ // check if record exist
			   		if($response === 'No'){
			   			$notes = 'No';
			   			$updateResponse = $this->apiDbConnection->table(TABLE::DELIVERY_CONFIRMATION)
												  ->where([
												    		['orno', '=', $order_number],
												    		['delivery_date', '=', $deliveryDate],

				    								])->update(['response' => $response, 'notes'=> $notes,'response_on'=>$today]);
			   		} else {
			   			try{
			   				if($channel=='IVR'){
			   						$updateResponse = $this->apiDbConnection->table(TABLE::DELIVERY_CONFIRMATION)
												  ->where([
												    		['orno', '=', $order_number],
												    		['delivery_date', '=', $deliveryDate],

				    								])->update(['response' => $response,'response_on'=>$today,'cType'=>'IVR']);
			   				} else {
			   					$updateResponse = $this->apiDbConnection->table(TABLE::DELIVERY_CONFIRMATION)
												  ->where([
												    		['orno', '=', $order_number],
												    		['delivery_date', '=', $deliveryDate],

				    								])->update(['response' => $response,'response_on'=>$today]);
			   				}

			   			} catch (Exception $e)
				        {
				            var_dump($e->getMessage());die();
				        }

			   		}

					if($updateResponse){
						$res = array(
							'status'=>true,
							'message'=>"Delivery Confirmation Updated successfully",
						);
						return response()->json($res,200);
					} else{
						return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
					}
				} else {
					return response()->json(array('status' => 404,'message' => 'Sorry, could not find any records for this order in Delivery confirmation Table'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}


}
