<?php

namespace App\Http\Controllers\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
use App\Helpers\TableHelper as TABLE;
//use TABLE;
use App\Helpers\SmsHelper;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\DeliveryTrait;
use App\Http\Traits\AuthenticationTrait;



class DeliveryController extends Controller
{
	protected $apiDbConnection;
	use DeliveryTrait;
	use AuthenticationTrait;
	public function __construct()
    {
		$this->apiDbConnection 	=  DB::connection('sqlsrv_api');

	}

	public function getDeliverySlots(Request $request)
	{
        $method 			= 	$request->method();
		$params 			= 	$request->all();
		$order_number 		= 	$this->cleanString($request->input('order_number'));
    	$country_code 		= 	$this->cleanString($request->input('country_code'));
		$user_ip_address 	= 	ServerHelper::instance()->getIpAddress(); // getting user ip address


		// $table_name 		= 	TABLE::ORDER_HEADS; // getting namespace constant
		// $cons1 			= 	ApiHelper::MYCONST; // getting namespace constant
		// $cons2 			= 	TWO; // getting global constant composer.json -> autoload -> files

		if($method != 'GET'){
			return response()->json(array('status' => 400,'message' => 'Bad request.'));
		} else {
			$params = $_REQUEST;
	        if(isset($params['order_number']) && isset($params['country_code'])){
	        	if(($params['order_number']!='' || $params['order_number']!=null) && ($params['country_code']!='' || $params['country_code']!=null)){
	        		// $order_number 			= 	stripslashes($request->input('order_number'));
		        	// $country_code 			= 	stripslashes($request->input('country_code'));

		        	// $this->apiDbConnection->enableQueryLog();

					$check_given_details 	= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
											            ->join(TABLE::BRANCHES.' as br', 'oh.t_cofc', '=', 'br.salesOffice')
								        				->select('t_orno as OrderId', 't_odat as OrderDate','t_hdst as OrderStatus','t_ddat as scheduledShipDate',
								        					't_corn as web_order_reference',

								        						DB::raw('CONVERT(varchar,t_odat, 100) as OrderDate_readable'),
								        						DB::raw('CONVERT(varchar,t_ddat, 100) as scheduledShipDate_readable')
								        						)
								        				->where([
														    		['oh.t_orno', '=', $order_number],
														    		['br.company', '=', $country_code],
														    		['oh.t_sotp ', '<>', 'MSO'],
																	['oh.t_sotp ', '<>', 'MSR'],
																	['oh.t_sotp ', '<>', 'SR1'],
																	['oh.t_hdst ', '<>', '35'],
															])
								        				->get();

						// $query = $this->apiDbConnection->getQueryLog();
						// dd($query);

					if(count($check_given_details) > 0 )
					{


						$time_slot = $this->recheck_delivery_slots($country_code,$order_number);
						$response 	= 	array(
    										"order_id" => $order_number,
							        		"timeslots"=>$time_slot
							        	);
			    		return response()->json($response,200);
					} else {
						return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
					}
				} else {
	        		return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        	}

	        } else {
	        	return response()->json(array('status' => 400,'message' => 'Bad request. Please check the missing parameters'));
	        }
		}
	}

	public function recheck_delivery_slots($country_code,$order_number){

		$user 			= 	auth()->user();
		//$channel 		= 	$this->getChannelByEmail($user->email);

		// $notAllowDates 		= 	['2022-06-01','2022-06-02'];
		// $allowSpecialDates 	= 	['2022-05-29'];
  		$notAllowDates 			= 	['2023-05-24'];
		$allowSpecialDates 		= 	[];

  		// check is valid record & take delivery date
		$date_time 					= 	date("Y-m-d H:i:s");
		$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
																            ->select('oh.t_orno as order_number','oh.t_cofc as branch_code','oh.t_cdec as deliveryTerm',
																            	DB::raw('cast(t_ddat as date) as deliveryDate'),
																        )
																            ->where([
																			    		['oh.t_orno', '=', $order_number],
																			    		['oh.t_sotp ', '<>', 'MSO'],
																						['oh.t_sotp ', '<>', 'MSR'],
																						['oh.t_sotp ', '<>', 'SR1'],
																						['oh.t_hdst ', '<>', '35'],
																				])
																            ->first();


		// echo "<pre>";
		// print_r($order_header_response);
		// echo $order_header_response->branch_code;die();
		$selectedDates = [];
		if(!empty($order_header_response))
		{
			$selectedDates[] = $order_header_response->deliveryDate;
			// check delivery request exist
			$deliveryRequest 	= 	$this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)
																	               ->select('t_unid as id','t_comp as company','t_brch as branch','t_orno as orderNumber',
																	               	DB::raw('cast(t_ddat as date) as deliveryDate'),
																	        		)
																	               ->where([
																				    		['t_comp', '=', $country_code],
																				    		['t_brch', '=', $order_header_response->branch_code],
																				    		['t_orno', '=', $order_number],
																				    ])
																	               ->get();
			if(count($deliveryRequest) > 0){
				foreach($deliveryRequest as $key=>$value){
	       			$selectedDates[] = $value->deliveryDate;
	       		}
	       	}
			$date_result 	= $this->apiDbConnection->table(TABLE::SCHEDULE_AVAILABLE.$country_code)
							                   ->select(DB::raw('MAX(t_ddat) as max_date'))
												->get();
			$max_date 		= $date_result[0]->max_date;
	    	$time_slot 		= array();

			if($country_code == '777'){
				$restrictedDay = 'Sun';
			} else {
				$restrictedDay = 'Fri';
			}

	    	// Newly added
			for($i=1;$i<20;$i++){
					$timestamp 	= strtotime($max_date. ' + '.$i.' days');
					$day 		= date('D', $timestamp);
					if($day!=$restrictedDay){
						$new_date = date('Y-m-d', strtotime($max_date. ' + '.$i.' days'));
						if (in_array($new_date, $selectedDates) == false && count($time_slot)<8){
							array_push($time_slot,$new_date);
						}
					}
				}
			// Newly added

	    	// remove not allowing dates
	    	foreach($time_slot as $key=>$date){

	       			if (in_array($date, $notAllowDates) == true)
	       			{
					    unset($time_slot[$key]);
					}
			}


	    	//add special delivery dates
			foreach($allowSpecialDates as $key=>$date){

	       			if (in_array($date, $time_slot) == false)
	       			{
					    $time_slot[] = $date;
					}
			}

			asort($time_slot); // sort by dates values
			$time_slot = array_values($time_slot); // rearrange the array
	    	return $time_slot;
		} else {
			return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
		}
	}

	public function scheduleDeliveryByOrder(Request $request)
	{

		//Multiple records can be possible for tracking re schedule history

		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));
		$order_number 				= 	$this->cleanString($request_data['order_id']);
		$schedule_date 				= 	$this->cleanString($request_data['schedule_date'])." 05:00:00.000";
		$requestDeliveryDate     	= 	$this->cleanString($request_data['schedule_date']);



//		$user 			= 	auth()->user();
//		$channel 		= 	$this->getChannelByEmail($user->email);



		$consignment_delivery_date 	= '';
		$date_type = 0;
		if(isset($request_data['delivery_date'])){
			if($request_data['delivery_date'] == '2035-12-31'){
				$date_type = 2;
			} else {
				$date_type = 1;
			}
			$consignment_delivery_date = $this->cleanString($request_data['delivery_date']);
		}

		$check_delivery_status 		= 	$this->checkDeliveryStatus($country_code,$order_number);

		if($check_delivery_status!=false){

			$scheduled_shipdate_time_format 		= strtotime($check_delivery_status['order_data']->scheduled_shipdate);
			$order_head_delivery_date_time_format 	= strtotime($check_delivery_status['order_data']->order_head_delivery_date);
			$previous_delivery_date 				= date('Y-m-d',$scheduled_shipdate_time_format);
			$order_head_delivery_date 				= date('Y-m-d',$order_head_delivery_date_time_format);
			$current_date   						= date("Y-m-d");
			$next_date 								= date('Y-m-d', strtotime($current_date. ' + 1 days'));

			//find and check the latest delivery schedule date for this order( is today (or) tomorrow )
			//if the previous schedule date is today or tomorrow then dont proceed for rescheddule
			if($previous_delivery_date==$current_date || $previous_delivery_date==$next_date){
				return response()->json(array('status' => 409,'message' => 'Delivery can’t be scheduled for today or tomorrow.'));
			}

			if($check_delivery_status['order_data']->order_status=='In Process' || $check_delivery_status['order_data']->order_status=='Free' || $check_delivery_status['order_data']->order_status=='Blocked'){
				$check_delivery_slots_response = $this->recheck_delivery_slots($country_code,$order_number);
				$sch_date_time 	= strtotime($schedule_date);
				$sch_date 		= date('Y-m-d',$sch_date_time);
				// recheck re-schedule date is still available
				if (in_array($sch_date, $check_delivery_slots_response))
				{
				  	$today 						= 	date("Y-m-d H:i:s");
					$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
																            ->select('oh.t_orno as order_number','oh.t_cofc as branch_code','oh.t_cdec as deliveryTerm')
																            ->where([
																			    		['oh.t_orno', '=', $order_number],
																			    		['oh.t_sotp ', '<>', 'MSO'],
																						['oh.t_sotp ', '<>', 'MSR'],
																						['oh.t_sotp ', '<>', 'SR1'],
																						['oh.t_hdst ', '<>', '35'],
																				])
																            ->first();
					if(!empty($order_header_response)){ // check order head details available
						$max_id_res 		= 	$this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)
														            ->select(
														            	DB::raw('max(t_unid) as id')
														            )->first();


						$max_id 			= 	$max_id_res->id+1;
						$record 			= 	array(
														't_unid' 		=>	$max_id,
														't_comp'		=> 	$country_code,
												        't_brch'		=>	$order_header_response->branch_code,
												        't_orno'		=>	$order_number,
												        't_ddat'		=>	$schedule_date,
												        't_cpay'   		=>  $order_header_response->deliveryTerm,
												        't_crvl'		=>	'Available : 999',
												        't_fxmn'		=>	0,
												        't_adby'		=>	'chatbot',
												        't_adon'		=>	$today,
												        //'t_rqst'		=>	'NEW',
														//'t_flag'		=>  7,
														't_rqst'		=>	'DONE',
														't_flag'		=>  0,
												        't_emsg'		=>  '',
												        't_Refcntd'		=>  0,
												        't_Refcntu'		=>  0,
												        't_rcd_vers'	=>  0
												);


						// if($channel == 'WHATSAPP' && $this->isOnlineOrder($order_header_response->branch_code))
						// {
						// 	// from whatsapp && online
				  //   		$record['t_flag'] = 0;
				  //   		$record['t_rqst'] = 'DONE';
				  //   	}

				    	if($this->isOnlineOrder($order_header_response->branch_code))
						{
							// from whatsapp && online
				    		$record['t_flag'] = 0;
				    		$record['t_rqst'] = 'DONE';
				    	}


						$check_record_status 	= 	$this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)
																               ->select('t_unid as id','t_comp as company','t_brch as branch','t_orno as orderNumber','t_ddat as deliveryDate'
																        		)
																               ->where([
																			    		['t_comp', '=', $country_code],
																			    		['t_brch', '=', $order_header_response->branch_code],
																			    		['t_orno', '=', $order_number],
																			    		// ['t_ddat','=',  $schedule_date]

																				])
																               ->get();

						// Check Any previous delivery request placed for this order
						if(count($check_record_status) > 0){
							$date_available=FALSE;
							// Business Requirment is to check Only Previous day check please enable this code ( OPTION A )
								// $schedule_response 	= 	$this->checkScheduleDateAvailable($country_code,$order_header_response->branch_code,$order_number);
								// 	if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){
								// 		if($schedule_response->scheduled_shipdate==$schedule_date){ // check rescheduling date is match with previous schedule date
								// 		$date_available=TRUE;
								// 	}
								// }
							//

							// Business Requirment is to check all the Previous day's check please enable this code ( OPTION B )
								foreach ($check_record_status as $key => $value) {
									if($value->deliveryDate==$schedule_date){ // check rescheduling date is match with anyone of the previous schedule date
										$date_available=TRUE;
									}
								}
							//

							if($date_available){ // Check rescheduling date is same
								return response()->json(array('status' => 409,'message' => 'Delivery can’t be rescheduled on a previous date.',
																'previous_schedule_dates'=>$check_record_status));
							} else {
								// Store New Schedule date if schedule date is not match with previous dates
								$response = $this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)->insert($record);
								if($date_type == 1){
									$this->updateDeliveryConfirmationStatus($requestDeliveryDate,$consignment_delivery_date,$order_number);
								} else if($date_type == 2){
									$this->updateDeliverySchedulingStatus($requestDeliveryDate,$consignment_delivery_date,$order_number);
								}

							}
						} else {
							// Store as New Schedule date there is no more delivery request for this order
							$response = $this->apiDbConnection->table(TABLE::DELIVERY_REQUEST)->insert($record);
							if($date_type == 1){
									$this->updateDeliveryConfirmationStatus($requestDeliveryDate,$consignment_delivery_date,$order_number);
							} elseif($date_type == 2){
								$this->updateDeliverySchedulingStatus($requestDeliveryDate,$consignment_delivery_date,$order_number);
							}
						}
						if($response){
							$request_data['status'] 	= 	"SUCCESS";
							$request_data['schedule_date_readable'] 	= 	date_format(date_create($schedule_date),"d-M-Y h:i:sa");
							return response()->json($request_data);
						} else{
							return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
						}
					} else {
						return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
					}
				} else {
				  	return response()->json(array('status' => 409,'message' => 'Delivery can’t be scheduled on the mentioned date.',
																				'available_dates'=>$check_delivery_slots_response));
				}
			} else {
				return response()->json(array('status' => 409,'message' => 'Sorry, your order can’t be rescheduled for delivery. Please contact our support team.'));
			}
		} else {
			return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
		}
	}

	public function updateDeliveryConfirmationStatus($requestDeliveryDate,$previousDeliveryDate,$order_number){

		$today 						= 	date("Y-m-d H:i:s");
		$this->apiDbConnection 		=  	DB::connection('dbcrm');
		$notes 						= 	'The user rescheduled the delivery date to '.$requestDeliveryDate;
		$response 					= 	'No';
		$updateResponse = $this->apiDbConnection->table(TABLE::DELIVERY_CONFIRMATION)
							  ->where([
							    		['orno', '=', $order_number],
							    		['delivery_date', '=', $previousDeliveryDate],

								])->update(['response' => $response, 'notes'=> $notes,'response_on'=>$today]);
	}

	public function updateDeliverySchedulingStatus($requestDeliveryDate,$previousDeliveryDate,$order_number){

		$today 						= 	date("Y-m-d H:i:s");
		$notes 						= 	'The user Updated Schedule date to '.$requestDeliveryDate;
		$response 					= 	'SCHED';
		$editedBy                   =   'WHATSAPP';
		$requestedDate 				= 	$requestDeliveryDate;
		$updateResponse = $this->apiDbConnection->table(TABLE::DELIVERY_SCHEDULING)
							->where([
							    		['orno', '=', $order_number],
							    		['delivery_date', '=', $previousDeliveryDate],
							])->update(['response' => $response,'editedBy' => $editedBy, 'notes'=> $notes,'response_on'=>$today,'requestedDate'=>$requestedDate]);


	}

	public function getDeliveryTerms($order_number,$company,$deliveryTerm,$salesOffice){

		$deliveryCapacity 		= 	$this->apiDbConnection->table(TABLE::DELIVERY_CAPACITY.' as dc')
													            ->select('dc.id','dc.company','dc.fixingMinutes','dc.fixingBuffer','dc.fixingBufferOnline','dc.fixingBufferOthers','dc.numberOrders','dc.volume','dc.csCapacity','dc.excludeTerms')
													            ->where([
																    		['dc.company', '=', $company]
																	])
													            ->first();

		$deliveryTermsExclusion = explode(',', $deliveryCapacity->excludeTerms);

		$dTerm = trim($deliveryTerm);

		$soSql = $sql = "select * from ".TABLE::ORDER_HEADS.$company." oh left join ".TABLE::SALES_ORDER_ADDITIONAL.$company." oad on (oh.t_orno=oad.t_orno)
				left join ttcmcs041".$company." dt on (oh.t_cdec = dt.t_cdec)
				where oh.t_orno ='".trim($order_number)."'";

		$soDetails = $this->apiDbConnection->select( DB::raw($soSql));
		$soFixing = $soDetails[0]->t_fixt;
		if (trim($salesOffice) === 'SLSWSU' || trim($salesOffice) === 'SLSWSO' || trim($salesOffice) === 'SLSWSQ' || trim($salesOffice) === 'SLSWSK')
        {
            $onlineOrder = true;
        } else
        {
            $onlineOrder = false;
        }

		if (trim($deliveryTerm) ==='DEX' && $onlineOrder === false)
        {
            $allowDex = true;
        }else{
            $allowDex = false;
        }
        if ( ! in_array($dTerm, $deliveryTermsExclusion))
        {

        } else {

        }
		var_dump($salesOffice);
		var_dump($onlineOrder);
		die();
	}
}
