<?php

namespace App\Http\Controllers\Order;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Schedule;
use App\Helpers\ServerHelper;
use App\Helpers\DateHelper;
use App\Helpers\OrdersHelper;
use App\Helpers\ApiHelper;
//use TABLE;
use App\Helpers\TableHelper as TABLE;
use Illuminate\Support\Facades\Config;
use App\Http\Traits\ScheduleTrait;

class ComplaintController extends Controller
{
	protected $apiDbConnection;
	use ScheduleTrait;

	public function __construct()
    {
		$this->apiDbConnection   =  DB::connection('sqlsrv_api');

	}


    public function createComplaint(Request $request)
	{
		$method 			= 	$request->method();
		$request_data 		= 	$request->json()->all();
		$country_code 		= 	$this->cleanString($request->input('country_code'));
		if (array_key_exists("OrderNumber",$request_data) && array_key_exists("ItemCode",$request_data) && array_key_exists("ComplaintDescription",$request_data) && array_key_exists("complaint_type",$request_data))
		{
			if($request_data['OrderNumber']!='' && $request_data['ItemCode']!='' && $request_data['ComplaintDescription']!='' && $request_data['complaint_type']!=''){

				$order_number 				= 	strtoupper($this->cleanString($request_data['OrderNumber']));
				$item_code 					=   '         '.$this->cleanString($request_data['ItemCode']);  //added 9 speaces here
				$country_code 				=   $this->cleanString($request->input('country_code'));

				$complaint_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_COMPLAINTS)
														            ->select('id','customer','order_number','item')
														            ->where([
																	    		['order_number', '=', $order_number],
																	    		['item', '=', $request_data['ItemCode']],
																	    		['status', '<>', '1'],
																		])
														            ->first();
				// check same order number & item number is already exist with status!=1
				if(empty($complaint_response)){
					$order_header_response 		= 	$this->apiDbConnection->table(TABLE::ORDER_HEADS.$country_code.' as oh')
													            ->select('oh.t_odat as order_date','oh.t_ofbp as customer_id','oh.t_ddat as delivery_date','oh.t_cofc as office_code',

													            	DB::raw('CONVERT(varchar,oh.t_odat, 100) as order_date_readable'),
													            	DB::raw('CONVERT(varchar,oh.t_ddat, 100) as delivery_date_readable')
													        	)
													            ->where([
																    		['oh.t_orno', '=', $order_number],
																    		['oh.t_sotp ', '<>', 'MSO'],
																			['oh.t_sotp ', '<>', 'MSR'],
																			['oh.t_sotp ', '<>', 'SR1'],
																			['oh.t_hdst ', '<>', '35'],
																	])
													            ->first();
				   	if(!empty($order_header_response)){
				   		$item_detail_response 		= 	$this->apiDbConnection->table(TABLE::ITEM_DETAILS)
														            ->select('t_item','t_sdsc','t_pcod')
														            ->where([
																	    		['t_item', '=', $item_code]
																		])
														            ->get();


						if(count($item_detail_response)>0){
							// check branch and item code condition
							if(($order_header_response->office_code=='SLS021' || $order_header_response->office_code=='SLS023') && ($item_detail_response[0]->t_pcod=='ESCLR' || $item_detail_response[0]->t_pcod=='ESCLRW')){
								return response()->json(array('status' => 409,'message' => 'Registering complains is not applicable on clearance items, Please contact our Customer Service team for further assistance.'));
							}
							//check record available in x2_delivery_request table

							$schedule_response 	= 	$this->checkScheduleDateAvailable($country_code,$order_header_response->office_code,$order_number);

							if($schedule_response->scheduled_shipdate!='' && $schedule_response->scheduled_shipdate_readable!=''){
								$order_header_response->delivery_date 			= $schedule_response->scheduled_shipdate;
								$order_header_response->delivery_date_readable 	= $schedule_response->scheduled_shipdate_readable;
							}

							//Add warranty info
							$warranty_date = $this->add_warranty($order_header_response->delivery_date);

							/////////// check add complaints option
							$today 				= 	date("Y-m-d");
							// $warranty_date = '2021-09-04';
							if ($today > $warranty_date) {
							    return response()->json(array('status' => 409,'message' => 'Item Out of warranty.'));
							}
							//////////////////////////

							$now 				= 	time();
							$today 				= 	date("Y-m-d h:i:s");
							$delivery_date 		= 	strtotime($order_header_response->delivery_date);
                            $date_diff 			= 	DateHelper::instance()->dateDiff($now,$delivery_date);
                            $item_code 			= 	$request_data['ItemCode'];
							$order_number 		= 	$request_data['OrderNumber'];
							$item 				=   '         '.$request_data['ItemCode'];  //added 9 speaces here

                            $iCoo 				= 	OrdersHelper::instance()->getCoo($item);
                            $iMfg 				= 	OrdersHelper::instance()->getCmnf($item);
                            $iDepartment 		= 	OrdersHelper::instance()->getDept($item);

                            if($country_code=='777'){
								$complaint_status = 9;
							} else {
								$complaint_status = 0;
							}

							$complaint_types 	= 	array("","Item Defected","Fixing Required","Request Replacement","Request Exchange");
							$record 			= 	array(
														// 'id' 			=> 	$complaint_id,
												        'customer' 		=> 	$order_header_response->customer_id,
												        'order_number'	=>	$order_number,
												        'company'		=> 	$country_code,
												        'order_date'	=>	$order_header_response->order_date,
												        'order_del_date'=>	$order_header_response->delivery_date,
												        'daysGap'		=>	$date_diff,
												        'rDept'			=>	$date_diff<3 ? 'DT' : 'CST',
												        'created' 		=> 	$today,
												        'text' 			=> 	$request_data['ComplaintDescription'],
												        'item'			=>	$item_code,
												        'branch'		=>	'',
												        'salesOffice'	=>	$order_header_response->office_code,
												        'status'		=>	$complaint_status,
												        'reason'		=>	99,
												        'createdByN'	=>	"chatbot",
												        'iCoo'			=>	$iCoo,
												        'iMfg'			=>	$iMfg,
												        'iDepartment'	=>	$iDepartment,
												        'csStatus'		=>	'NEW',
												        'itemDesc'		=>	$item_detail_response[0]->t_sdsc,
												        'complaint_type'=>  $request_data['complaint_type']
													);

							// $this->apiDbConnection->unprepared('SET IDENTITY_INSERT inforerpdb.dbo.order_complaints ON');
							$response = $this->apiDbConnection->table(TABLE::ORDER_COMPLAINTS)->insertGetId($record);
						    // $this->apiDbConnection->unprepared('SET IDENTITY_INSERT inforerpdb.dbo.order_complaints OFF');

							if($response){
								$complaint_id = $response;
								$res = array(
									'complaint_id'				=>	$complaint_id,
									'creation_date'				=>	$today,
									'creation_date_readable'	=>	date("d-M-y H:m:s"),
									'status'					=>	200,
									'status_code'				=>	'NEW',
									'reference'					=>	$order_number,
									'complaint_description'		=>	$request_data['ComplaintDescription'],
									'complaint_type'        	=>	$request_data['complaint_type'],
									'complaint_type_readable' 	=>  $complaint_types[$request_data['complaint_type']]
								);
								return response()->json($res,200);
							} else{
								return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
							}
						} else {
							return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
						}
					} else {
						return response()->json(array('status' => 404,'message' => 'Order Details Not Available'));
					}
				} else {
					return response()->json(array('status' => 409,'message' => 'Complaint already Exist for this order number and item code.'));
				}
			} else {
			   	return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
		  	return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}

	public function getComplaints(Request $request)
	{

		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));

		if (array_key_exists("OrderNumber",$request_data))
		{
			if($request_data['OrderNumber']!=''){
				$order_number = $this->cleanString($request_data['OrderNumber']);
				$order_complaints_response 	= 	$this->apiDbConnection->table(TABLE::ORDER_COMPLAINTS.' as oc')
													            ->select('oc.id as complaint_id','oc.created as creation_date','oc.csStatus as status','oc.item as reference','text as complaint_description','oc.complaint_type',
													            		DB::raw('CONVERT(varchar,oc.created, 100) as creation_date_readable'),
													            		//DB::raw('FORMAT(oc.created, \'dd-MMM-yyy HH:mm:ss\') as creation_date_readable'),
													            		DB::raw('(CASE
																			WHEN complaint_type = \'1\' THEN \'Item Defected\'
																			WHEN complaint_type = \'2\' THEN \'Fixing Required\'
																			WHEN complaint_type = \'3\' THEN \'Request Replacement\'
																			WHEN complaint_type = \'4\' THEN \'Request Exchange\'
																			ELSE \'Not Applicable\'
																			END) AS complaint_type_readable')
													        	)
													            ->where([
																    		['oc.order_number', '=', $order_number],
																    		// ['oc.csStatus', '!=', 'CLOSED'],
																	])
													            ->get();
				if($order_complaints_response->count()>0){
					return response()->json($order_complaints_response,200);
				} else {
					return response()->json(array('status' => 404,'message' => 'Sorry, could not find any complaints for the order '.$order_number));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}
	public function updateComplaints(Request $request)
	{

		$method 					= 	$request->method();
		$request_data 				= 	$request->json()->all();
		$country_code 				= 	$this->cleanString($request->input('country_code'));
		$status_array 				= 	["NEW","CLOSED"];
		$today 						= 	date("Y-m-d h:i:s");
		if (array_key_exists("OrderNumber",$request_data) && array_key_exists("Status",$request_data) && array_key_exists("ComplaintId",$request_data) && array_key_exists("Reference",$request_data))
		{
			if($request_data['OrderNumber']!='' && $request_data['ComplaintId']!="" && $request_data['Reference']!="" && $request_data['Status']!=""){


				$order_number 	= 	$this->cleanString($request_data['OrderNumber']);
				$complaint_id 	= 	$this->cleanString($request_data['ComplaintId']);
				$reference_no 	=  	$this->cleanString($request_data['Reference']);
				$csStatus 		= 	$this->cleanString($request_data['Status']);
				$starRating 	= 	$this->cleanString($request_data['rating']);

				if(!is_numeric($request_data['rating']) || is_float($request_data['rating'])){
					return response()->json(array('status' => 400,'message' => 'Invalid Parameter, Type rating should be always integer'));
				}

				$order_complaints_response 	= 	$this->apiDbConnection->table(TABLE::ORDER_COMPLAINTS.' as oc')
													            ->select('oc.id as complaint_id','oc.created as creation_date','oc.status','oc.item as reference','text as complaint_description')
													            ->where([
																    		['oc.order_number', '=', $order_number],
																    		['oc.id', '=', $complaint_id],
																    		['oc.item', '=', $reference_no],
																    		['oc.company', '=', $country_code],
																	])
													            ->get();
				if($order_complaints_response->count()>0){ // check if record exist
					$status_value = in_array($request_data['Status'], $status_array);
					if($status_value==false){
						return response()->json(array('status' => 400,'message' => 'Invalid Status Format'));
					}

					if($request_data['Status']=='CLOSED'){
						$complaint_status = 1;
					} else {
						if($country_code=='777'){
							$complaint_status = 9;
						} else {
							$complaint_status = 0;
						}
					}

					$response = $this->apiDbConnection->table(TABLE::ORDER_COMPLAINTS)
													  ->where([
													    		['order_number', '=', $order_number],
																['id', '=', $complaint_id],
																['item', '=', $reference_no],
																['company', '=', $country_code]
					    								])->update(['csStatus' => $csStatus,'status' => $complaint_status,'closed' => $today,'rating' =>$starRating]);


					if($response){
						$request_data['Status'] 	= 	$status_array[$status_value];
						return response()->json($request_data);
					} else{
						return response()->json(array('status' => 500,'message' => 'There was an error on the server and the request could not be completed'));
					}
				} else {
					return response()->json(array('status' => 404,'message' => 'Sorry, could not find any complaints for this order'));
				}
			} else {
				return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
			}
		} else {
			return response()->json(array('status' => 400,'message' => 'Invalid arguments'));
		}
	}



}
