<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

/**
 * @OA\Info(
 *     title="Pan Home APIs",
 *     version="1.0.0"
 * )
 *
 * @OA\SecurityScheme(
 *     securityScheme="bearerAuth",
 *     type="http",
 *     scheme="bearer",
 *     bearerFormat="JWT"
 * )
 */
class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;
    public function cleanString($string)
    {
        $string          =   stripslashes($string);
        $string          =   trim(str_replace("\r\n", '', $string));
        $string          =   trim(str_replace("\r", '', $string));
        $string          =   str_replace("'", "", $string);
        $string          =   str_replace(';', '', $string);
        return $string;
    }
}
