<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Support\Facades\Storage;
use Throwable;


class AuthController extends Controller
{

    /**
     * Hardcoded login for two fixed users. Accepts JSON body:
     * {
     *   "userName": "string",
     *   "password": "string"
     * }
     *
     * @OA\Post(
     *     path="/api/login",
     *     operationId="loginHardcoded",
     *     summary="Login (hardcoded) and return raw JWT token",
     *     tags={"Auth"},
     *     @OA\RequestBody(
     *         required=true,
     *         @OA\JsonContent(
     *             required={"userName","password"},
     *             @OA\Property(property="userName", type="string", example="apiDevU2"),
     *             @OA\Property(property="password", type="string", example="123456")
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="JWT string",
     *         @OA\MediaType(
     *             mediaType="text/plain",
     *             @OA\Schema(
     *                 type="string",
     *                 example="eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1bmlxdWVfbmFtZSI6InVzZXIxIiwicm9sZSI6ImFkbWluIiwibmJmIjoxNzU3NDA2NTkzLCJleHAiOjE3NTc0MTAxOTMsImlhdCI6MTc1NzQwNjU5M30.m7WplTtqAfdSKEFz0q27WF9zS2P5DNwgGt2A7UfrmMw"
     *             )
     *         )
     *     ),
     *     @OA\Response(response=401, description="Unauthorized")
     * )
     */
public function login(\Illuminate\Http\Request $request)
{
 //   public function apilogin(Request $request)
  //  {

        $data = $request->validate([
            'email' => 'required|string',
            'password' => 'required|string',
        ]);
        $users = [
            'pmo@karix.com' => ')BpJyYwa22MJ*',
            'apiDevU2' => '123456',
            'apiDevU1' => '123456',
        ];

        if (!isset($users[$data['email']]) || $users[$data['email']] !== $data['password']) {
            return response()->json(['message' => 'wrong credential'], 401);
        }
        $ttl = 3600; // seconds
        $now = time();
        $secret = env('JWT_SECRET', config('app.key'));

        // claims similar to your sample
        $payload = [
            'unique_name' => $data['email'],
            'role'        => 'user',
            'nbf'         => $now,
            'exp'         => $now + $ttl,
            'iat'         => $now,
        ];

        // Prefer Firebase\JWT if available; otherwise fallback to manual HS256
        if (class_exists(\Firebase\JWT\JWT::class) && class_exists(\Firebase\JWT\Key::class)) {
            $token = \Firebase\JWT\JWT::encode($payload, $secret, 'HS256');
        } else {
            $token = $this->jwtEncodeHs256($payload, $secret);
        }

        return response($token, 200)->header('Content-Type', 'text/plain');
    }


    /* ========= Minimal HS256 fallback (base64url, sign, verify) ========= */

    private function b64urlEncode(string $data): string
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }

    private function b64urlDecode(string $data): string
    {
        $pad = 4 - (strlen($data) % 4);
        if ($pad < 4) $data .= str_repeat('=', $pad);
        $out = base64_decode(strtr($data, '-_', '+/'));
        return $out === false ? '' : $out;
    }

    private function jwtEncodeHs256(array $payload, string $secret): string
    {
        $header = ['alg' => 'HS256', 'typ' => 'JWT'];
        $h = $this->b64urlEncode(json_encode($header, JSON_UNESCAPED_SLASHES));
        $p = $this->b64urlEncode(json_encode($payload, JSON_UNESCAPED_SLASHES));
        $sig = hash_hmac('sha256', "$h.$p", $secret, true);
        $s = $this->b64urlEncode($sig);
        return "$h.$p.$s";
    }

    /**
     * @return array|false
     */
    private function jwtDecodeHs256(string $token, string $secret)
    {
        $parts = explode('.', $token);
        if (count($parts) !== 3) return false;

        [$h64, $p64, $s64] = $parts;
        $header = json_decode($this->b64urlDecode($h64), true);
        $payload = json_decode($this->b64urlDecode($p64), true);
        $sig = $this->b64urlDecode($s64);

        if (!is_array($header) || !is_array($payload)) return false;
        if (($header['alg'] ?? '') !== 'HS256') return false;

        $expected = hash_hmac('sha256', "$h64.$p64", $secret, true);
        if (!hash_equals($expected, $sig)) return false;

        $now = time();
        if (isset($payload['nbf']) && $payload['nbf'] > $now) return false;
        if (isset($payload['exp']) && $payload['exp'] <= $now) return false;

        return $payload;
    }


  /**
     * Append a one-line structured log to storage/logs/update_delivery.txt
     */
    private function writeDeliveryLog(
        bool $success,
        int $timeMs,
        string $executedBy,
        string $ip,
        ?string $ua,
        array $payload,
        int $status,
        string $resultSnippet
    ): void {
        $line = sprintf(
            "[%s] success=%s time_ms=%d by=%s ip=%s ua=\"%s\" order_id=%s response=%s delivery_date=%s status=%d result=%s\n",
            now()->format('Y-m-d H:i:s'),
            $success ? 'yes' : 'no',
            $timeMs,
            $executedBy,
            $ip,
            $ua ?? 'n/a',
            $payload['order_id'] ?? 'n/a',
            $payload['response'] ?? 'n/a',
            $payload['delivery_date'] ?? 'n/a',
            $status,
            substr(preg_replace('/\s+/', ' ', (string) $resultSnippet), 0, 500)
        );

        Storage::disk('local')->append('logs/update_delivery.txt', $line);
    }


 /**
     * Safely decode claims without verifying signature (for logging "executed by" only).
     */
    private function extractClaims(string $jwt): array
    {
        $parts = explode('.', $jwt);
        if (count($parts) !== 3) return [];
        $p64 = $parts[1];
        $pad = 4 - (strlen($p64) % 4);
        if ($pad < 4) $p64 .= str_repeat('=', $pad);
        $json = base64_decode(strtr($p64, '-_', '+/'), true);
        $arr  = json_decode($json ?: '[]', true);
        return is_array($arr) ? $arr : [];
    }


  private static function base64UrlDecode($data)
    {
        return base64_decode(strtr($data, '-_', '+/'));
    }



public function getinfo()
{

	$token='eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1bmlxdWVfbmFtZSI6ImFwaURldlUyIiwicm9sZSI6InVzZXIiLCJuYmYiOjE3NjY1NjIyNzQsImV4cCI6MTc2NjU2NTg3NCwiaWF0IjoxNzY2NTYyMjc0fQ.HqZpChWR3xpCtQT_4LImpRofs8GUrHxfEma05H1MIy0';
	$userInfo =  \App\Helpers\ApiHelper::getUserInfo($token);
	return response()->json($userInfo);

}





}
