<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Auth;

class AuthController extends Controller
{
    public function login(Request $request){
    	$loginData = $request->validate([
    		'email'=>'email|required',
    		'password'=>'required'
    	]);
    	if(!auth()->attempt($loginData)){
    		return response(['message'=>'invalid credentials']);
    	}
    	$accessToken = auth()->user()->createToken('authToken')->accessToken;
    	return response(['user'=>auth()->user(),'access_token'=>$accessToken]);
    }
}
