<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;


class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
   /* public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }
*/


 public function register(): void
    {
        $this->renderable(function (MethodNotAllowedHttpException $e, $request) {
            // Only for API routes (adjust the condition if you keep APIs elsewhere)
            if ($request->is('api/*')) {
                // Optionally surface the allowed methods from the exception headers
                $allowed = $e->getHeaders()['Allow'] ?? null;

                return response()->json([
                    'status'  => false,
                    'message' => 'Method Not Allowed',
                    // 'allowed_methods' => $allowed, // <- uncomment if you want this detail
                ], 405, $allowed ? ['Allow' => $allowed] : []);
            }
        });
    }



public function render($request, Throwable $e)
{
    if ($e instanceof MethodNotAllowedHttpException) {
        return response()->json([
            'status'  => false,
            'message' => 'Method Not Allowed',
        ], 405);
    }

    return parent::render($request, $e);
}





}
