import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

from app.database.connection import SessionLocal
from hashlib import sha256
from sqlalchemy import select
from sqlalchemy import create_engine, text

DATABASE_URL = "mssql+pyodbc://report:reports@192.168.0.111/ln?driver=ODBC+Driver+17+for+SQL+Server"


try:
    engine = create_engine(DATABASE_URL)
    with engine.connect() as conn:
        result = conn.execute(text("SELECT 1"))
        print("Connected:", result.scalar())
except Exception as e:
    print("Connection failed:", e)


from hashlib import sha256
from sqlalchemy import select
from app.database.connection import SessionLocal
from app.models.user import tbl_user

def verify_user(username: str, password: str) -> bool:
    db = SessionLocal()
    try:
        stmt = select(tbl_user.c.username, tbl_user.c.password_hash).where(tbl_user.c.username == username)
        result = db.execute(stmt).fetchone()

        if result is None:
            print("❌ User not found")
            return False

        db_username, db_hash = result
        input_hash = sha256(password.encode()).hexdigest()

        if db_hash == input_hash:
            print("✅ Login successful")
            return True
        else:
            print("❌ Password mismatch")
            print("DB hash:    ", db_hash)
            print("Input hash: ", input_hash)
            return False
    finally:
        db.close()
