from fastapi import APIRouter, HTTPException
from app.schemas.user_schema import UserLogin
from app.services.auth_service import verify_user, create_jwt_token

router = APIRouter()

@router.post("/login")
def login(user: UserLogin):
    is_valid = verify_user(user.username, user.password)
    if is_valid:
        token = create_jwt_token(user.username)
        return {"access_token": token, "token_type": "bearer"}
    raise HTTPException(status_code=401, detail="Invalid credentials")
