from fastapi import APIRouter, Depends
from sqlalchemy import select
from app.database.connection import SessionLocal
from app.models.aramax import x2_aramax_track_ids
from app.schemas.aramax_schema import AramaxTrackItem
from app.services.token_helper import verify_jwt_token  # ✅ Add this

router = APIRouter()

@router.get("/aramax-orders", response_model=list[AramaxTrackItem], tags=["Aramax Orders"])
def get_aramax_orders(user: str = Depends(verify_jwt_token)):  # ✅ Secure with JWT
    """
    Protected: Returns Aramax tracking data. Requires a valid JWT token.
    """
    db = SessionLocal()
    try:
        stmt = select(x2_aramax_track_ids)
        result = db.execute(stmt).mappings().all()
        return result
    finally:
        db.close()
