from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from fastapi.security import HTTPBearer
from app.routes import auth_routes, aramax_routes,click_collect_routes

app = FastAPI(
    title="PAN HOME API",
    description="PAN HOME API",
    version="1.0"
)

# Optional: allow Swagger UI to test endpoints across origins (if needed)
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_methods=["*"],
    allow_headers=["*"],
)

app.include_router(auth_routes.router)
app.include_router(aramax_routes.router)
app.include_router(click_collect_routes.router)
 # ✅ register it


